Name: galera
Version: 25.3.31
Release: alt1
Summary: Synchronous multi-master wsrep provider (replication engine)
Group: System/Servers
License: GPLv2
Url: http://galeracluster.com/
# VCS-git: https://github.com/codership/galera.git
Source: %name-%version.tar

Source1: garbd.init
Source2: garbd.service
Source3: garbd.tmpfiles
Source4: garbd.conf

# git submodules
Source100: wsrep.tar

BuildRequires: gcc-c++ scons
BuildRequires: boost-devel boost-program_options-devel asio-devel
BuildRequires: libcheck-devel libssl-devel zlib-devel

%description
Galera is a fast synchronous multi-master wsrep provider (replication engine)
for transactional databases and similar applications. For more information
about wsrep API see http://launchpad.net/wsrep. For a description of Galera
replication engine see http://www.codership.com.

%package garbd
Summary: Galera arbitrator
Group: System/Servers

%description garbd
Galera is a fast synchronous multi-master wsrep provider (replication engine)
for transactional databases and similar applications. For more information
about wsrep API see http://launchpad.net/wsrep. For a description of Galera
replication engine see http://www.codership.com.

This package contain Galera arbitrator.

%package -n libgalera_smm
Summary: Synchronous multi-master wsrep provider (replication engine)
Group: System/Libraries

%description -n libgalera_smm
Galera is a fast synchronous multi-master wsrep provider (replication engine)
for transactional databases and similar applications. For more information
about wsrep API see http://launchpad.net/wsrep. For a description of Galera
replication engine see http://www.codership.com.

%prep
%setup
tar -xf %SOURCE100 -C wsrep/src

%build
export CPPFLAGS="%optflags"
scons %{?_smp_mflags} strict_build_flags=0 boost=1 system_asio=1 boost_pool=1 

%install
install -D -m 755 %SOURCE1 %buildroot%_initdir/garbd
install -D -m 644 %SOURCE2 %buildroot%_unitdir/garbd.service
mkdir -p %buildroot{%_localstatedir,%_logdir}/garbd
install -D -m 644 %SOURCE3 %buildroot%_tmpfilesdir/garbd.conf
install -D -m 644 %SOURCE4 %buildroot%_sysconfdir/garbd/garbd.conf
install -D -m 755 garb/garbd %buildroot%_sbindir/garbd
install -D -m 644 libgalera_smm.so %buildroot%_libdir/galera/libgalera_smm.so
install -D -m 644 COPYING %buildroot%_docdir/galera/COPYING
install -D -m 644 chromium/LICENSE %buildroot%_docdir/galera/LICENSE.chromium
install -D -m 644 asio/LICENSE_1_0.txt %buildroot%_docdir/galera/LICENSE.asio
install -D -m 644 scripts/packages/README %buildroot%_docdir/galera/README
install -D -m 644 scripts/packages/README-MySQL %buildroot%_docdir/galera/README-MySQL

%pre garbd
groupadd -r -f _garbd
useradd -r -g _garbd -c "Galera Arbitrator Daemon" -d %_localstatedir/garbd -s /dev/null -M -N _garbd >/dev/null 2>&1 ||:

%post garbd
%post_service garbd

%preun garbd
%preun_service garbd

%files -n libgalera_smm
%dir %_libdir/galera
%_libdir/galera/libgalera_smm.so

%files garbd
%dir %_sysconfdir/garbd
%config(noreplace) %_sysconfdir/garbd/garbd.conf
%dir %_docdir/galera
%attr(0750,_garbd,_garbd) %dir %_localstatedir/garbd
%attr(3770,root,_garbd) %dir %_logdir/garbd
%_sbindir/garbd
%_unitdir/garbd.service
%_initdir/garbd
%_tmpfilesdir/garbd.conf
%doc %_docdir/galera/COPYING
%doc %_docdir/galera/LICENSE.asio
%doc %_docdir/galera/LICENSE.chromium
%doc %_docdir/galera/README
%doc %_docdir/galera/README-MySQL

%changelog
