Name: gambit
Version: 4.7.7
Release: alt1.1

Summary: Gambit-C Scheme programming system
License: Apache-2.0
Group: Development/Other
URL: http://www.iro.umontreal.ca/~gambit/
Conflicts: ghostscript-minimal < 8.64-alt5

Packager: Paul Wolneykien <manowar@altlinux.org>

%def_without bootstrap

Source: %name-%version.tar
%if_with bootstrap
Patch0: %name-%version-bootstrap.patch
%define bootstrap_version 4.7.6
BuildRequires: gambit >= %bootstrap_version
%endif

# Automatically added by buildreq on Wed Oct 08 2008
BuildRequires: emacs-leim emacs-nox libX11-locales libncurses-devel /usr/bin/texi2html /usr/bin/texi2dvi /usr/bin/pdf2ps /usr/bin/gs perl(Encode.pm) perl(Unicode/Normalize.pm) tetex-latex

BuildPreReq: alternatives
# explicitly added texinfo for info files
BuildRequires: texinfo

%description
Gambit-C includes a Scheme interpreter and a Scheme compiler which can be used
to build standalone executables. Because the compiler generates portable C
code it is fairly easy to port to any platform with a decent C compiler.

The Gambit-C system conforms to the R4RS and IEEE Scheme standards.  The full
numeric tower is implemented, including: infinite precision integers (bignums),
rationals, inexact reals (floating point numbers), and complex numbers.

%package -n emacs-gambit
Summary: Emacs mode for Gambit-C
Group: Editors
Requires: gambit emacs-common
BuildArch: noarch

%description -n emacs-gambit
Emacs mode for running Gambit-C

%package docs
Summary: Gambit-C manuals ang examples
Group: Development/Documentation
Requires: gambit = %version-%release
BuildArch: noarch

%description docs
Gambit-C manuals ang examples

%package info
Summary: Gambit-C manual in info format
Group: Development/Documentation
Requires: gambit = %version-%release
BuildArch: noarch

%description info
Gambit-C manual in info format

# See GAMBCDIR_LIB (doesn't work, TODO)
#define _libdir %_prefix/%_lib/gambit
%define pkgdocdir %_docdir/%name-%version

%prep
%setup -q -c %name
# Redirect REPL to stdout to avoid hangs in Hasher
find %name-%version -name 'makefile.in' -exec sed -i -e 's/gs[ci]\(-boot\)\? -:/&d-,/g' '{}' \;
%if_with bootstrap
# Prepare the bootstrap tree
cp -Rp %name-%version %name-%version-bootstrap-2
cp -Rp %name-%version %name-%version-bootstrap-1
pushd %name-%version-bootstrap-1
%patch0 -p1
popd
%endif
cd %name-%version

%build
%if_with bootstrap
pushd %name-%version-bootstrap-1
cp /usr/bin/gsc gsc-boot
if [ "%bootstrap_version" = "$(./gsc-boot -v | sed -n 's/^v\([0-9]\+\.[0-9]\+\.[0-9]\+\).*$/\1/p')" ]; then \
	autoconf configure.ac > configure && chmod 755 configure; \
	%configure --enable-single-host; \
	%make bootclean; \
	%make_build bootstrap; \
fi
cp gsc-boot ../%name-%version-bootstrap-2/
popd
%endif

%if_with bootstrap
pushd %name-%version-bootstrap-2
if [ "%version" != "$(./gsc-boot -v | sed -n 's/^v\([0-9]\+\.[0-9]\+\.[0-9]\+\).*$/\1/p')" ]; then \
	autoconf configure.ac > configure && chmod 755 configure; \
	%configure --enable-single-host; \
	%make bootclean; \
	%make_build bootstrap; \
fi
cp gsc-boot ../%name-%version/
popd
%endif

cd %name-%version
autoconf configure.ac > configure && chmod 755 configure
# TODO: try --enable-poll
%configure --enable-single-host \
           --enable-shared \
           --disable-absolute-shared-libs
%if_without bootstrap
%make bootstrap
%endif
%make bootclean
%make_build
emacs -q -no-site-file -batch -eval "(byte-compile-file \"misc/gambit.el\")"

%install
cd %name-%version
%makeinstall_std
rm -rf $RPM_BUILD_ROOT%_prefix/doc
for f in $RPM_BUILD_ROOT%_bindir/scheme-*; do
    mv $f $f-%name
done
rm examples/*/makefile*
install -m644 misc/*.el* %buildroot%_emacslispdir/

install -d $RPM_BUILD_ROOT%_altdir
cat > $RPM_BUILD_ROOT%_altdir/%name <<EOF
%_bindir/scheme-r5rs		%_bindir/scheme-r5rs-gambit		10
%_bindir/scheme-r4rs		%_bindir/scheme-r4rs-gambit		10
%_bindir/scheme-srfi-0		%_bindir/scheme-srfi-0-gambit		10
%_bindir/scheme-ieee-1178-1990	%_bindir/scheme-ieee-1178-1990-gambit	10
EOF

# docs
mkdir -p %buildroot%pkgdocdir
cp -R doc/gambit-c.pdf doc/gambit-c.txt doc/gambit-c.html examples/* %buildroot%pkgdocdir/

%check
cd %name-%version
%make -C tests check

%files
%_altdir/*
%_bindir/*-%name
%_bindir/gambc*
%_bindir/gsc*
%_bindir/gsi*
%_bindir/six*
%_includedir/*.h
%_libdir/*.so*
%_libdir/*.scm
%_libdir/_*.c
%_man1dir/*.1.*

%files -n emacs-gambit
%_emacslispdir/*

%files docs
%pkgdocdir/

%files info
%_infodir/*.info*

%changelog
