Name: gawk
Version: 4.1.0
Release: alt2

%def_with doc
%define _libexecdir %prefix/libexec

Summary: The GNU version of the awk text processing utility
License: GPLv3+
Group: Text tools
Url: http://www.gnu.org/software/gawk/

# git://git.altlinux.org/gears/g/gawk.git
Source: %name-%version-%release.tar

Provides: awk = %version, dgawk = %version, gawk-profile = %version
Obsoletes: dgawk < %version, gawk-profile < %version

BuildRequires: libreadline-devel makeinfo
# Automatically added by buildreq on Sat Sep 22 2012
# optimized out: fontconfig fonts-type1-urw ghostscript-classic ghostscript-common gnu-config groff-base tex-common texlive-base texlive-base-bin texlive-common texlive-latex-base tzdata
%{?_with_doc:BuildRequires: ghostscript-utils groff-ps texi2dvi texlive-generic-recommended}
%{?!_without_check:%{?!_disable_check:BuildRequires: /dev/pts}}

%description
This packages contains the GNU version of awk, a text processing utility.
Awk interprets a special-purpose programming language to do quick
and easy text pattern matching and reformatting jobs.  Gawk should be
upwardly compatible with the Bell Labs research version of awk and is
almost completely compliant with the 1993 POSIX 1003.2 standard for awk.

%package doc
Summary: Documentation about the GNU version of the awk text processing utility
Group: Text tools
BuildArch: noarch
Requires: %name = %version-%release

%description doc
This packages contains documentation about the GNU version of the awk
text processing utility.

%prep
%setup -n %name-%version-%release

%build
./bootstrap.sh
rm awkgram.c command.c version.c doc/*.info awklib/eg/prog/igawk.sh awklib/stamp-eg
%configure --bindir=/bin --without-libsigsegv-prefix
# SMP-incompatible
make awkgram.c command.c
%make_build
%if_with doc
cd doc
%make_build gawk.dvi awkcard.pdf
dvipdf gawk.dvi
cd -
%endif

%install
%makeinstall_std
rm %buildroot%_libdir/gawk/*.la
rm %buildroot/bin/*-%{version}*
mkdir -p %buildroot%_bindir
mv %buildroot/bin/?gawk %buildroot%_bindir/
ln -s ../../bin/gawk %buildroot%_bindir/
for n in awk dgawk pgawk; do
	ln -s gawk %buildroot%_bindir/$n
	ln -s gawk.1 %buildroot%_man1dir/$n.1
done

%define docdir %_docdir/%name-%version
mkdir -p %buildroot%docdir
install -pm644 AUTHORS NEWS POSIX.STD README \
	%{?_with_doc:doc/{gawk,awkcard}.pdf} %buildroot%docdir/

%find_lang %name

%check
%make_build -k check diffout

%files -f %name.lang
/bin/*
%_bindir/*
%_datadir/awk/
%_libdir/gawk/
%_libexecdir/awk/
%_includedir/*.h
%_infodir/*.info*
%_mandir/man?/*

%dir %docdir
%docdir/[A-Z]*

%if_with doc
%files doc
%dir %docdir
%docdir/*.pdf
%endif

%changelog
