# BEGIN SourceDeps(oneline):
BuildRequires: /usr/bin/less /usr/bin/perl /usr/bin/pg /usr/sbin/zdump libncurses-devel libtinfo-devel
# END SourceDeps(oneline)
%global gcalmantag 4

Name:		gcal
Version:	4
Release:	alt1_2.1
Summary:	GNU Gregorian calendar program

Group:		Text tools
License:	GPLv3+
URL:		http://www.gnu.org/software/gcal/
Source0:	ftp://ftp.gnu.org/gnu/gcal/%{name}-%{version}.tar.xz
# The man pages are not shipped in tarball but reside in the git repository.
# To fetch the man pages, do:
# $ gcalmantag=3.6
# $ git archive --format=tar v${gcalmantag} -- doc/en/man | \
#     gzip -c > gcal-man-v${gcalmantag}.tar.gz
Source1:	gcal-man-v%{gcalmantag}.tar.gz
BuildRequires:	gettext ncurses-devel
Requires(post): info
Requires(preun): info

# Gnulib is granted exception of "no bundled libraries" packaging guideline:
# https://fedoraproject.org/wiki/Packaging:No_Bundled_Libraries#Packages_granted_exceptions
Provides: bundled(gnulib)
Source44: import.info
# explicitly added texinfo for info files
BuildRequires: texinfo

%description
Gcal is a program for calculating and printing calendars.  Gcal
displays hybrid and proleptic Julian and Gregorian calendar sheets.
It also displays holiday lists for many countries around the globe.

%prep
%setup -q
tar xf %{SOURCE1}


%build
CFLAGS="%{optflags}"
export CFLAGS
%configure
make %{?_smp_mflags}


%check
make check


%install
make install DESTDIR=%{buildroot} INSTALL="install -p"
install -dm 755 %{buildroot}%{_mandir}/man1
install -pm 644 doc/en/man/*.1 %{buildroot}%{_mandir}/man1
rm -f %{buildroot}%{_datadir}/%{name}/Makefile.in
rm -f %{buildroot}%{_infodir}/dir
%find_lang %{name}


%files -f %{name}.lang
%doc AUTHORS BUGS COPYING LIMITATIONS NEWS README THANKS TODO
%{_bindir}/gcal
%{_bindir}/gcal2txt
%{_bindir}/tcal
%{_bindir}/txt2gcal
%{_datadir}/gcal/
%{_infodir}/*.info*
%{_mandir}/man1/*.1*

%changelog
