Name: gd2
Version: 2.0.35
Release: alt6

Summary: A graphics library for drawing image files in various formats
License: BSD-style
Group: Graphics
Url: http://www.libgd.org/Main_Page

%define srcname gd-%version
# http://www.libgd.org/releases/gd-%version.tar.bz2
Source: %srcname.tar

Patch: gd-%version-%release.patch

# Automatically added by buildreq on Mon Mar 26 2007
BuildRequires: fontconfig-devel libXpm-devel libfreetype-devel libjpeg-devel libpng-devel

%def_disable static

%package -n lib%name
Summary: A graphics library for drawing image files in various formats
Group: System/Libraries

%package -n lib%name-devel
Summary: Development library and header files for lib%name
Group: Development/C
Requires: lib%name = %version-%release
Conflicts: libgd-devel < 2.0.4

%package -n lib%name-devel-static
Summary: Development static library for lib%name
Group: Development/C
Requires: lib%name-devel = %version-%release
Conflicts: libgd-devel-static < 2.0.4

%package utils
Summary: Utilities for drawing image files in various formats
Group: Graphics
Requires: lib%name = %version-%release
Conflicts: gd-utils < 2.0.4

%description
Gd is a graphics library.  It allows your code to quickly draw images
complete with lines, arcs, text, multiple colors, cut and paste from
other images, and flood fills, and write out the result as a PNG or
JPEG file.  This is particularly useful in World Wide Web applications,
where PNG and JPEG are two of the formats accepted for inline images
by most browsers.

Gd is not a paint program.  If you are looking for a paint program, you
are looking in the wrong place.  If you are not a programmer, you are
looking in the wrong place, unless you are installing a required
library in order to run an application.

Gd does not provide for every possible desirable graphics operation.
It is not necessary or desirable for Gd to become a kitchen-sink
graphics package, but version 2.0 does include most frequently
requested features, including both truecolor and palette images,
resampling (smooth resizing of truecolor images) and so forth.

%description -n lib%name
Gd is a graphics library for drawing image files in various formats.  Gd
allows your code to quickly draw images (lines, arcs, text, multiple colors,
cutting and pasting from other images, flood fills) and write out the result
as a jpeg, png or wbmp file.  Gd is particularly useful in web applications,
where jpeg, png or wbmp files are commonly used as inline images.  Note,
however, that Gd is not a paint program.

%description -n lib%name-devel
Gd is a graphics library for drawing image files in various formats.  Gd
allows your code to quickly draw images (lines, arcs, text, multiple colors,
cutting and pasting from other images, flood fills) and write out the result
as a jpeg, png or wbmp file.  Gd is particularly useful in web applications,
where jpeg, png or wbmp files are commonly used as inline images.  Note,
however, that Gd is not a paint program.

%description -n lib%name-devel-static
Gd is a graphics library for drawing image files in various formats.  Gd
allows your code to quickly draw images (lines, arcs, text, multiple colors,
cutting and pasting from other images, flood fills) and write out the result
as a jpeg, png or wbmp file.  Gd is particularly useful in web applications,
where jpeg, png or wbmp files are commonly used as inline images.  Note,
however, that Gd is not a paint program.

%description utils
Gd is a graphics library.  It allows your code to quickly draw images
complete with lines, arcs, text, multiple colors, cut and paste from
other images, and flood fills, and write out the result as a PNG or
JPEG file.  This is particularly useful in World Wide Web applications,
where PNG and JPEG are two of the formats accepted for inline images
by most browsers.

Gd is not a paint program.  If you are looking for a paint program, you
are looking in the wrong place.  If you are not a programmer, you are
looking in the wrong place, unless you are installing a required
library in order to run an application.

Gd does not provide for every possible desirable graphics operation.
It is not necessary or desirable for Gd to become a kitchen-sink
graphics package, but version %version does include most frequently
requested features, including both truecolor and palette images,
resampling (smooth resizing of truecolor images) and so forth.

%prep
%setup -n %srcname
%patch -p1

%build
%autoreconf
%configure %{subst_enable static}
%make_build

%install
%makeinstall_std

%define docdir %_docdir/%srcname
rm -rf %buildroot%docdir
mkdir -p %buildroot%docdir
cp -a index.html COPYING %buildroot%docdir/

%check
%make_build -k check

%files -n lib%name
%_libdir/*.so.*
%dir %docdir
%docdir/COPYING

%files -n lib%name-devel
%_libdir/*.so
%_includedir/*
%_pkgconfigdir/*.pc
%_bindir/gdlib-config
%dir %docdir
%docdir/index.html

%if_enabled static
%files -n lib%name-devel-static
%_libdir/*.a
%endif #static

%files utils
%_bindir/*
%exclude %_bindir/gdlib-config

%changelog
