%define ver_major 3.24
%define api_ver 1.0

%define _libexecdir %_prefix/libexec
%define _localstatedir %_var

%define default_pam_config redhat
# Initial virtual terminal to use
%define vt_nr 1

%def_disable static
%def_disable debug
%def_enable ipv6
%def_with xinerama
%def_with xdmcp
%def_with tcp_wrappers
%def_with selinux
%def_with libaudit
%def_with plymouth
%def_without xevie
%def_enable wayland
%def_enable xsession
#Enable running X server as user
%def_enable user_display_server

Name: gdm
Version: %ver_major.3
Release: alt0.M80P.1

Summary: The GNOME Display Manager
License: GPLv2+
URL: http://wiki.gnome.org/Projects/GDM
Group: Graphical desktop/GNOME

Source: ftp://ftp.gnome.org/pub/gnome/sources/%name/%ver_major/%name-%version.tar.xz
#Source: %name-%version.tar
Source1: gdm_xdmcp.control
Source2: gdm.wms-method

# PAM config files
Source10: gdm.pam
Source11: gdm-autologin.pam
Source12: gdm-password.pam
Source13: gdm-launch-environment.pam
Source14: gdm-smartcard.pam
Source15: gdm-fingerprint.pam

Patch2: gdm-3.19.4-alt-Xsession.patch
Patch7: gdm-3.1.92-alt-Init.patch
Patch11: gdm-3.8.0-alt-lfs.patch

Obsoletes: %name-gnome
Provides: %name-gnome = %version-%release
Provides: gnome-dm

# from configure.ac
%define glib_ver 2.36.0
%define gtk_ver 3.16.0
%define shell_ver 3.19.4
%define libcanberra_ver 0.4
%define accountsservice_ver 0.6.35
%define check_ver 0.9.4

Provides: %name-user-switch-applet = %version-%release
Obsoletes: %name-user-switch-applet

PreReq: %_rpmlibdir/update-dconf-database.filetrigger
Requires: %name-libs = %version-%release
Requires: %name-data = %version-%release
Requires: gnome-shell >= %shell_ver
Requires: coreutils xinitrc iso-codes lsb-release shadow-utils
# since 3.11.92
Requires: caribou
Requires: gnome-session >= 3.7.1
Requires: gnome-session-wayland
Requires: gnome-settings-daemon >= 3.15.90

BuildPreReq: gcc-c++ desktop-file-utils gnome-common rpm-build-gnome
BuildPreReq: intltool >= 0.40.0 yelp-tools itstool
BuildPreReq: iso-codes-devel
BuildPreReq: glib2-devel >= %glib_ver libgio-devel
BuildPreReq: libgtk+3-devel >= %gtk_ver
BuildPreReq: libaccountsservice-devel >= %accountsservice_ver
BuildPreReq: dconf
BuildRequires: systemd-devel libsystemd-devel
%{?_with_selinux:BuildPreReq: libselinux-devel libattr-devel}
%{?_with_libaudit:BuildPreReq: libaudit-devel}
%{?_with_plymouth:BuildPreReq: plymouth-devel}
BuildPreReq: libpam-devel
%{?_with_tcp_wrappers:BuildPreReq: libwrap-devel}
BuildPreReq: libcanberra-devel >= %libcanberra_ver libcanberra-gtk3-devel
BuildRequires: libXdmcp-devel

BuildRequires: libX11-devel libXau-devel libXrandr-devel libXext-devel libXft-devel libSM-devel
BuildRequires: libXi-devel xorg-inputproto-devel libXinerama-devel xorg-xineramaproto-devel libXevie-devel
BuildRequires: xorg-xephyr xorg-server

BuildPreReq: libcheck-devel >= %check_ver

BuildRequires: libdmx-devel
BuildRequires: librsvg-devel perl-XML-Parser docbook-dtds xsltproc zenity
BuildRequires: gobject-introspection-devel
BuildRequires: libdaemon-devel
# for check
BuildRequires: /proc dbus-tools-gui xvfb-run

%description
Gdm (the GNOME Display Manager) is a highly configurable
reimplementation of xdm, the X Display Manager. Gdm allows you to log
into your system with the X Window System running and supports running
several different X sessions on your local machine at the same time.

%package data
Summary: Arch independent files for GDM
Group: Graphical desktop/GNOME
BuildArch: noarch
Conflicts: gdm2.20

%description data
This package provides noarch data needed for GDM to work.

%package libs
Summary: GDM libraries
Group: System/Libraries

%description -n %name-libs
This package contains shared libraries needed for GNOME Display Manager
to work.

%package libs-devel
Summary: Development files for GDM libraries
Group: Development/C
Requires: %name-libs = %version-%release

%description libs-devel
This package contains headers and development libraries for GNOME
Display Manager.

%package libs-gir
Summary: GObject introspection data for the GDM
Group: System/Libraries
Requires: %name-libs = %version-%release

%description libs-gir
GObject introspection data for the GDM libraries.

%package libs-gir-devel
Summary: GObject introspection devel data for the GDM
Group: Development/Other
BuildArch: noarch
Requires: %name-libs-gir = %version-%release
Requires: %name-libs-devel = %version-%release

%description libs-gir-devel
GObject introspection devel data for the GDM libraries.

%package help
Summary: User documentation for Gdm
Group: Graphical desktop/GNOME
BuildArch: noarch
Conflicts: %name < %version-%release

%description help
Gdm (the GNOME Display Manager) is a highly configurable
reimplementation of xdm, the X Display Manager. Gdm allows you to log
into your system with the X Window System running and supports running
several different X sessions on your local machine at the same time.

This package contains user documentation for Gdm.

%prep
%setup
%patch2 -p1 -b .Xsession
%patch7 -p1 -b .Init
%patch11 -p1 -b .lfs

# just copy our PAM config files to %default_pam_config directory
cp %SOURCE10 %SOURCE11 %SOURCE12 %SOURCE13 %SOURCE14 %SOURCE15  data/pam-%default_pam_config/

%build
[ ! -d m4 ] && mkdir m4
%autoreconf
%configure \
	%{subst_enable static} \
	--disable-schemas-compile \
	%{subst_enable ipv6} \
	%{subst_enable debug} \
	--with-sysconfsubdir=X11/gdm \
	%{subst_with xinerama} \
	%{subst_with xdmcp} \
	%{?_with_tcp_wrappers:--with-tcp-wrappers} \
	--with-pam-prefix=%_sysconfdir \
	--with-default-pam-config=%default_pam_config \
	%{subst_with xevie} \
	%{subst_with libaudit} \
	%{subst_with plymouth} \
	--with-default-path="/bin:/usr/bin:/usr/local/bin" \
	--with-initial-vt=%vt_nr \
	--with-dmconfdir=%_sysconfdir/X11/sessions \
	--disable-dependency-tracking \
	%{?_enable_wayland:--enable-wayland-support} \
	%{?_enable_xsession:--enable-gdm-xsession} \
	--with-pam-mod-dir=%_pam_modules_dir \
	%{?_disable_user_display_server:--disable-user-display-server}
%make_build

%install
mkdir -p %buildroot%_sysconfdir/X11/sessions
mkdir -p %buildroot%_sysconfdir/X11/wms-methods.d

%makeinstall_std
rm -f %buildroot%_sysconfdir/pam.d/gdm

# env.d directories
mkdir -p %buildroot{%_sysconfdir/X11,%_datadir}/gdm/env.d

# install external hook for update_wms
install -m755 %SOURCE2 %buildroot%_sysconfdir/X11/wms-methods.d/%name

find %buildroot -name '*.a' -delete
find %buildroot -name '*.la' -delete

# control gdm/xdmcp
install -pDm755 %SOURCE1 %buildroot%_controldir/gdm_xdmcp

%find_lang %name
%find_lang --output=%name-help.lang --without-mo --with-gnome %name

%check
xvfb-run %make check

%pre
%pre_control gdm_xdmcp

%post
%post_control -s disabled gdm_xdmcp

%files
%_sbindir/gdm
%_bindir/gdm-screenshot
%_bindir/gdmflexiserver
%_libexecdir/gdm-host-chooser
%_libexecdir/gdm-session-worker
%_libexecdir/gdm-simple-chooser
%_libexecdir/gdm-wayland-session
%_libexecdir/gdm-x-session
%_pam_modules_dir/pam_gdm.so
%doc AUTHORS ChangeLog NEWS README TODO
%_unitdir/gdm.service

%files data -f %name.lang
#%config %_sysconfdir/pam.d/gdm
%config %_sysconfdir/pam.d/gdm-autologin
%config %_sysconfdir/pam.d/gdm-password
%config %_sysconfdir/pam.d/gdm-launch-environment
%config %_sysconfdir/pam.d/gdm-smartcard
%config %_sysconfdir/pam.d/gdm-fingerprint
%config %_sysconfdir/dbus-1/system.d/%name.conf
%config %_datadir/glib-2.0/schemas/org.gnome.login-screen.gschema.xml
%config(noreplace) %_sysconfdir/X11/%name
%dir %_sysconfdir/X11/sessions
%config %_controldir/gdm_xdmcp
%_sysconfdir/X11/wms-methods.d/%name
%dir %_datadir/%name
%_datadir/%name/locale.alias
%_datadir/%name/gdb-cmd
%_datadir/%name/%name.schemas
%dir %_datadir/%name/greeter
%dir %_datadir/%name/greeter/applications
%_datadir/%name/greeter-dconf-defaults
%_datadir/dconf/profile/%name
%_pixmapsdir/*
%_datadir/icons/*/*/*/*.*
%dir %_localstatedir/log/gdm
%attr(775, gdm, gdm) %dir %_localstatedir/cache/gdm
%attr(1770, gdm, gdm) %dir %_localstatedir/lib/gdm
%attr(1750, gdm, gdm) %dir %_localstatedir/lib/gdm/.local
%attr(1750, gdm, gdm) %dir %_localstatedir/lib/gdm/.local/share
%attr(1777, root, gdm) %dir %_localstatedir/run/gdm
%_datadir/gdm/greeter/applications/mime-dummy-handler.desktop
%_datadir/gdm/greeter/applications/mimeapps.list
%dir %_datadir/%name/greeter/autostart
%exclude %_datadir/gdm/greeter/autostart/orca-autostart.desktop

%files help -f %name-help.lang

%files libs
%_libdir/libgdm.so.*

%files libs-devel
%_includedir/gdm/
%_libdir/libgdm.so
%_libdir/pkgconfig/gdm.pc

%files libs-gir
%_typelibdir/Gdm-%api_ver.typelib

%files libs-gir-devel
%_girdir/Gdm-%api_ver.gir

%exclude %_sysconfdir/pam.d/gdm-pin

%changelog
