# Unpackaged files in buildroot should terminate build
%define _unpackaged_files_terminate_build 1

Name: geany
Version: 1.33
Release: alt0.M80P.1

Summary: A fast and lightweight IDE using GTK2
License: GPLv2
Group: Development/Tools
Url: http://geany.org

Source: %name-%version.tar.bz2

Requires: libvte
Requires: %name-data = %version
BuildPreReq: desktop-file-utils
# Automatically added by buildreq on Tue Jul 05 2016
# optimized out: fontconfig fontconfig-devel glib2-devel gnu-config libX11-devel libatk-devel libcairo-devel libfreetype-devel libgdk-pixbuf libgdk-pixbuf-devel libgio-devel libgpg-error libpango-devel libstdc++-devel libwayland-client libwayland-server perl-Encode perl-XML-Parser pkg-config python-base python-devel python-module-lxml python-modules python-modules-compiler python-modules-encodings xorg-xproto-devel
BuildRequires: gcc-c++ intltool libgtk+2-devel python-module-docutils time

%add_findreq_skiplist %_datadir/%name/templates/files/*

%description
Geany is a small and lightweight integrated development environment.
It was developed to provide a small and fast IDE, which has only a few
dependencies from other packages. Another goal was to be as
independent as possible from a special Desktop Environment like KDE or
GNOME. So it is using only the GTK2 toolkit and therefore you need
only the GTK2 runtime libraries to run Geany.

%package data
Summary: Data files for Geany IDE
Group: Development/Tools
BuildArch: noarch
Requires: %name = %version

%description data
Architecture-independent data files for Geany IDE.

%package devel
Summary: Header files for building Geany plug-ins
Group: Development/C
Requires: %name = %version

%description devel
This package contains the header files and pkg-config file needed for
building Geany plug-ins. You do not need to install this package to
use Geany.

%prep
%setup

# hack out space in file name
sed -i '/"untitled"/,/^$/s/\([^a-z]\) \([^a-z]\)/\1_\2/g' po/ru.po

# Add some hello world examples
# C++
cat > data/templates/files/hello_world.cpp <<@@@
{fileheader}

#include <iostream>

int main(int argc, char **argv)
{
	std::cout << "Hello world!\n";
	return 0;
}
@@@

# Basic
cat > data/templates/files/hello_world.bas <<@@@
{fileheader}
PRINT "Hello World!"
SLEEP
@@@

# Pascal
cat > data/templates/files/hello_world.pas <<@@@
{fileheader}

program Hello;
begin
  writeln ('Hello, world!');
end.
@@@

%build
NOCONFIGURE=1 ./autogen.sh

%configure --docdir=%_defaultdocdir/%name-%version --enable-html-docs

%make_build --silent --no-print-directory

%install
%makeinstall_std --silent --no-print-directory
%find_lang %name
bzip2 %buildroot%_defaultdocdir/%name-%version/ChangeLog

%check
%make check

%files
%_bindir/%name
%_libdir/%name/
%_libdir/*.so.*

%files -f %name.lang data
%_datadir/%name/
%_man1dir/%name.1.*
%_desktopdir/%name.desktop
%_iconsdir/*/*/*/*
%_defaultdocdir/%name-%version/

%files devel
%_includedir/%name/
%_pkgconfigdir/%name.pc
%_libdir/*.so

%changelog
