%def_disable snapshot
# hardcoded lib/geary path
#%%define _libexecdir %_prefix/libexec
%define ver_major 0.12
%define xdg_name org.gnome.Geary
%def_enable contractor

Name: geary
Version: %ver_major.0
Release: alt0.M80P.1

Summary: Email client
License: LGPLv2.1+
Group: Networking/Mail
Url: https://wiki.gnome.org/Apps/Geary

%if_disabled snapshot
Source: ftp://ftp.gnome.org/pub/gnome/sources/%name/%ver_major/%name-%version.tar.xz
%else
Source: %name-%version.tar
%endif

%define vala_ver 0.22.1
%define gtk_ver 3.12.0
%define sqlite_ver 3.12.0
%define gcr_ver 3.10.1

BuildRequires: vala-tools >= %vala_ver libvala-devel
BuildRequires: libgtk+3-devel >= %gtk_ver
BuildRequires: libsqlite3-devel >= %sqlite_ver
BuildRequires: cmake intltool desktop-file-utils gnome-doc-utils
BuildRequires: iso-codes-devel
BuildRequires: libnotify-devel libcanberra-devel libgee0.8-devel
BuildRequires: libgmime-devel libgnome-keyring-devel libexpat-devel
BuildRequires: libpixman-devel libharfbuzz-devel libwebkit2gtk-devel libenchant-devel
BuildRequires: libpng-devel libsecret-devel at-spi2-atk-devel libxml2-devel
BuildRequires: libXdmcp-devel libXdamage-devel libxshmfence-devel
BuildRequires: libXxf86vm-devel libXinerama-devel libXrandr-devel libXi-devel
BuildRequires: libXcursor-devel libXcomposite-devel libxkbcommon-devel
BuildRequires: libwayland-cursor-devel
BuildRequires: libat-spi2-core-devel at-spi2-atk-devel
BuildRequires: gobject-introspection-devel libgtk+3-gir-devel
BuildRequires: libsoup-gir-devel libwebkit2gtk-gir-devel libcanberra-vala
BuildRequires: gcr-libs-devel >= %gcr_ver gcr-libs-vala

%description
Geary is an email client built for the GNOME desktop environment.  It
allows you to read and send email with a simple, modern interface.

Visit http://www.yorba.org to read about the current state of.
Geary's development.

%prep
%setup

%build
%cmake -DGSETTINGS_COMPILE:BOOL=OFF \
	-DICON_UPDATE:BOOL=OFF \
	-DDESKTOP_UPDATE:BOOL=OFF
%cmake_build VERBOSE=1

%install
%cmakeinstall_std
%find_lang --with-gnome %name

%files -f %name.lang
%_bindir/%name
%{?_enable_contractor:%_bindir/%name-attach}
%_libexecdir/%name/
%_datadir/%name/
%_desktopdir/%xdg_name.desktop
%_desktopdir/%name-autostart.desktop
%_datadir/glib-2.0/schemas/%xdg_name.gschema.xml
%_iconsdir/*/*/apps/*
%_iconsdir/hicolor/scalable/actions/*.svg
%_datadir/appdata/%xdg_name.appdata.xml
%{?_enable_contractor:%_datadir/contractor/geary-attach.contract}
%doc AUTHORS NEWS README THANKS

%changelog
