%define ver_major 3.22
%def_enable python
%def_enable zeitgeist
%define gedit_pluginsdir %_libdir/gedit/plugins
%add_python3_path %gedit_pluginsdir

Name: gedit-plugins
Version: %ver_major.0
Release: alt0.M80P.1

Summary: Plugins for GEdit
License: GPL
Group: Editors
Url: https://wiki.gnome.org/Apps/Gedit/ShippedPlugins

#Source: %name-%version.tar
Source: %gnome_ftp/%name/%ver_major/%name-%version.tar.xz

%define glib_ver 2.40.0
%define gtk_ver 3.14.0
%define gtksourceview_ver 3.18.0
%define gedit_ver 3.22.0
%define peas_ver 1.14
%define git2_ver 0.0.12
%define vte_ver 0.38

Requires: gedit >= %ver_major
Requires: libpeas-python3-loader
Requires: libvte3-gir >= %vte_ver
%{?_enable_zeitgeist:Requires: zeitgeist}

AutoReqProv: nopython
%define __python %nil

BuildPreReq: rpm-build-gnome >= 0.6

# From configure.ac
BuildPreReq: gnome-common
BuildPreReq: intltool >= 0.35.0
BuildPreReq: glib2-devel >= %glib_ver
BuildPreReq: libgtk+3-devel >= %gtk_ver
BuildPreReq: libgtksourceview3-devel >= %gtksourceview_ver
BuildPreReq: gedit-devel >= %gedit_ver
BuildPreReq: libpeas-devel >= %peas_ver
BuildRequires: yelp-tools
# for git plugin
BuildRequires: libgit2-glib-devel >= %git2_ver
# for Charmap plugin
BuildPreReq: libgucharmap-devel >= 3.0.0 libgucharmap-gir-devel
%{?_enable_zeitgeist:BuildRequires: libzeitgeist2.0-devel libzeitgeist2.0-gir-devel}
%{?_enable_python:BuildRequires: rpm-build-python3 python3-devel python3-module-pygobject3-devel}
BuildRequires: libxml2-devel python3-module-dbus-devel libvte3-gir-devel

%description
gEdit is a small but powerful text editor designed expressly for GNOME.

It includes such features as split-screen mode, a plugin API, which
allows gEdit to be extended to support many features while remaining
small at its core, multiple document editing through the use of a
'tabbed' notebook and many more functions.

This package contains various plugins for gEdit, including Charmap, Terminal, and others.

%prep
%setup

%build
%autoreconf
%configure \
    --disable-static \
    --disable-schemas-compile

%make_build

%install
%makeinstall_std

%find_lang --with-gnome --output=%name.lang gedit %name

%files -f %name.lang
%dir %_datadir/gedit/plugins
%_datadir/gedit/plugins/*
%gedit_pluginsdir/*
%config %_datadir/glib-2.0/schemas/org.gnome.gedit.plugins.drawspaces.gschema.xml
%config %_datadir/glib-2.0/schemas/org.gnome.gedit.plugins.terminal.gschema.xml
%config %_datadir/glib-2.0/schemas/org.gnome.gedit.plugins.wordcompletion.gschema.xml
%_datadir/appdata/gedit-*.metainfo.xml
%exclude %gedit_pluginsdir/*.la

%changelog
