%def_disable snapshot
%define _libexecdir %_prefix/libexec

# ffmpegthumbnailer code is broken
%def_disable ffmpegthumbnailer

Name: geeqie
Version: 1.4
Release: alt0.M80P.1

Summary: Graphics file browser utility
License: GPLv2+
Group: Graphics

Url: http://%name.org
%if_disabled snapshot
Source: %url/%name-%version.tar.xz
%else
# VCS: http://www.geeqie.org/git/geeqie.git
Source: %name-%version.tar
%endif

Patch: %name-1.3-alt-lfs.patch
Patch1: %name-1.3-libdir-fix.patch

BuildRequires: gcc-c++ gnome-doc-utils intltool libgtk+2-devel libjpeg-devel
BuildRequires: liblcms2-devel liblirc-devel libtiff-devel libexiv2-devel
%{?_enable_ffmpegthumbnailer:BuildRequires: libffmpegthumbnailer-devel}
# while gtk+2 is a default
#BuildRequires: libchamplain-gtk3-devel

%description
Geeqie is a lightweight image viewer. It was forked from GQview. The development
is focused on features for photo collection maintenance: raw format, Exif/IPTC/XMP
metadata and integration with programs like UFraw, ImageMagick, Gimp, gPhoto or
ExifTool.

%prep
%setup
%patch -p1
%patch1 -p1 -b .libdir

subst 's/ChangeLog//
       s/ChangeLog\.html//' Makefile.am

%build
%add_optflags -Wno-error=unused-but-set-variable
%{?_enable_ffmpegthumbnailer:%add_optflags -Wno-error=unused-function}
%autoreconf
%configure --enable-lirc \
	--enable-largefile \
	--with-readmedir=%_datadir/%name \
	%{subst_enable ffmpegthumbnailer}
%make_build

%install
%makeinstall_std
install -pD -m644 %name.png %buildroot%_liconsdir/%name.png

%find_lang %name

%files -f %name.lang
%_bindir/%name
%_datadir/%name/
%_libdir/%name/
%_desktopdir/%name.desktop
%_pixmapsdir/%name.png
%_iconsdir/hicolor/*x*/apps/%name.png
%_man1dir/%name.1.*
%doc NEWS README.*

%changelog
