# Since version 3.0, the Python bindings are unsupported by upstream.
# See also http://trac.osgeo.org/geos/ticket/228
%def_without python
%def_without python3

Name: geos
Version: 3.6.2
Release: alt0.M80P.1

Summary: Geometry Engine - Open Source
Group: Sciences/Geosciences
License: LGPL
Url: http://trac.osgeo.org/geos/

Packager: Andrey Cherepanov <cas@altlinux.org>

# VCS: https://git.osgeo.org/gogs/geos/geos.git
Source: %name-%version.tar
Patch1: %name-fix-lib-destination.patch

BuildRequires(pre): rpm-build-ruby
BuildRequires: gcc-c++ python-devel swig
BuildPreReq: cmake doxygen graphviz
%if_with python3
BuildRequires(pre): rpm-build-python3
BuildPreReq: python3-devel
%endif

%description
GEOS (Geometry Engine - Open Source) is a C++ port of the Java
Topology Suite (JTS). As such, it aims to contain the complete
functionality of JTS in C++. This includes all the OpenGIS
"Simple Features for SQL" spatial predicate functions and
spatial operators, as well as specific JTS topology functions
such as IsValid().

%package doc
Summary: Documentation for GEOS
Group: Development/Documentation
BuildArch: noarch

%description doc
GEOS (Geometry Engine - Open Source) is a C++ port of the Java
Topology Suite (JTS). As such, it aims to contain the complete
functionality of JTS in C++. This includes all the OpenGIS
"Simple Features for SQL" spatial predicate functions and
spatial operators, as well as specific JTS topology functions
such as IsValid().

This package contains documentation for GEOS.

%package -n lib%name
Summary: Geometry Engine - Open Source
Group: Sciences/Geosciences
Provides:  libgeos1 = %EVR
Obsoletes: libgeos1 < %EVR

%description -n lib%name
GEOS (Geometry Engine - Open Source) is a C++ port of the Java
Topology Suite (JTS). As such, it aims to contain the complete
functionality of JTS in C++. This includes all the OpenGIS
"Simple Features for SQL" spatial predicate functions and
spatial operators, as well as specific JTS topology functions
such as IsValid().

%package -n lib%name-devel
Summary: Development files for the Geometry Engine - Open Source
Group: Development/C
Requires: lib%name = %version-%release

%description -n lib%name-devel
Development files for the Geometry Engine - Open Source

%if_with python
%package -n python-module-%name
Summary: Python bindings for the lib%name library
Group: Development/Python
Requires: lib%name = %version-%release

%description -n python-module-%name
Python bindings for the lib%name library.
%endif

%if_with python3
%package -n python3-module-%name
Summary: Python bindings for the lib%name library
Group: Development/Python3
Requires: lib%name = %version-%release

%description -n python3-module-%name
Python bindings for the lib%name library.
%endif

%package -n ruby-%name
Summary: Ruby bindings for the lib%name library
Group: Development/Ruby
Requires: lib%name = %version-%release

%description -n ruby-%name
Ruby bindings for the lib%name library.

%prep
%setup
%patch1 -p1

%if_with python3
cp -fR . ../python3
%endif

%build
./autogen.sh
%undefine _configure_gettext
%configure \
	--disable-static \
%if_with python
	--enable-python \
%else
	--disable-python \
%endif
	--disable-ruby

%if_with python3
pushd ../python3
sed -i 's|\(\-python\)|\1 -py3|' macros/ac_pkg_swig.m4
sed -i 's|python\$PYTHON_VERSION|python\${PYTHON_VERSION}m|' \
	macros/ac_python_devel.m4
export PYTHON=/usr/bin/python3
./autogen.sh
%configure \
	--disable-static \
	--enable-python \
	--disable-ruby
export PYTHON=
popd
%endif

%if %_lib == lib64
LIB_SUFFIX=64
%endif

%cmake_insource -DGEOS_BUILD_STATIC:BOOL=OFF
%make_build VERBOSE=1

%if_with python
%make -C swig/python LIB_SUFFIX=$LIB_SUFFIX \
	ENABLE_PYTHON=1 ENABLE_SWIG=1
%endif

%if_with python3
%make -C ../python3/swig/python LIB_SUFFIX=$LIB_SUFFIX \
	ENABLE_PYTHON=1 ENABLE_SWIG=1
%endif

%make -C doc doxygen-html

%install
%makeinstall_std

%if %_lib == lib64
LIB_SUFFIX=64
%endif

%if_with python
%makeinstall_std -C swig/python LIB_SUFFIX=$LIB_SUFFIX \
	ENABLE_PYTHON=1 ENABLE_SWIG=1
%endif

rm -f %buildroot%python_sitelibdir/geos/*.la
rm -f %buildroot%ruby_sitearchdir/*.la

%if_with python3
%makeinstall_std -C ../python3/swig/python LIB_SUFFIX=$LIB_SUFFIX \
	ENABLE_PYTHON=1 ENABLE_SWIG=1
rm -f %buildroot%python3_sitelibdir/geos/*.la
%endif

%check
make check || exit 0

%files -n lib%name
%doc AUTHORS COPYING NEWS README.md TODO
%_libdir/lib*.so.*

%files -n lib%name-devel
%_bindir/%name-config
%_libdir/lib*.so
%_includedir/*

%if_with python
%files -n python-module-%name
%python_sitelibdir/*
%endif

%if_with python3
%files -n python3-module-%name
%python3_sitelibdir/*
%endif

%if 0
%files -n ruby-%name
%ruby_sitearchdir/*
%endif

%files doc
%doc doc/doxygen_docs/html/*

%changelog
