%def_with qt4

Name: gimagereader
Version: 3.1.2
Release: alt3.M80P.2

Summary: A graphical GTK frontend to tesseract-ocr

License: GPLv3+
Group: Office
Url: https://github.com/manisandro/gImageReader

Packager: Vitaly Lipatov <lav@altlinux.ru>

# TODO: https://github.com/manisandro/gImageReader/archive/v%version.tar.gz
Source: http://sourceforge.net/projects/gimagereader/files/%version/%name-%version.tar

Patch1: gimagereader-alt-ru-in-desktop.patch
Patch2: gimagereader-fix-build-with-gtk.patch

BuildRequires(pre): rpm-macros-cmake

BuildRequires: cmake gcc-c++ libsane-devel tesseract-devel libgomp5-devel

# need pkgconfig from 3.04 and above
BuildRequires: tesseract-devel >= 3.04.00

# gtk
BuildRequires: libgtksourceviewmm3-devel libgtkspellmm3-devel libpoppler-glib-devel

%if_with qt4
BuildRequires: libqt4-devel libqtspell-qt4-devel libpoppler-qt4-devel
%endif

# qt5
BuildRequires: libqtspell-qt5-devel libpoppler-qt5-devel qt5-base-devel qt5-imageformats


# for compatibility
Requires: %name-gtk

%description
gImageReader is a simple Gtk front-end to tesseract. Features include:
 - Automatic page layout detection
 - User can manually define and adjust recognition regions
 - Import images from disk, scanning devices, clipboard and screenshots
 - Supports multipage PDF documents
 - Recognized text displayed directly next to the image
 - Editing of output text, including search/replace and removing line breaks
 - Spellchecking for output text (if corresponding dictionary installed)

%package gtk
Group: Office
Summary: A Gtk+ front-end to tesseract-ocr
Requires: %name-common = %version-%release
Obsoletes: %name < 2.94

%description gtk
gImageReader is a simple front-end to tesseract. Features include:
 - Automatic page layout detection
 - User can manually define and adjust recognition regions
 - Import images from disk, scanning devices, clipboard and screenshots
 - Supports multipage PDF documents
 - Recognized text displayed directly next to the image
 - Editing of output text, including search/replace and removing line breaks
 - Spellchecking for output text (if corresponding dictionary installed)
This package contains the Gtk+ front-end.

%package qt5
Group: Office
Summary: A Qt 5 front-end to tesseract-ocr
Requires: %name-common = %version-%release

%description qt5
gImageReader is a simple front-end to tesseract. Features include:
 - Automatic page layout detection
 - User can manually define and adjust recognition regions
 - Import images from disk, scanning devices, clipboard and screenshots
 - Supports multipage PDF documents
 - Recognized text displayed directly next to the image
 - Editing of output text, including search/replace and removing line breaks
 - Spellchecking for output text (if corresponding dictionary installed)
This package contains the Qt front-end.

%if_with qt4
%package qt4
Group: Office
Summary: A Qt4 front-end to tesseract-ocr
Requires: %name-common = %version-%release

%description qt4
gImageReader is a simple front-end to tesseract. Features include:
 - Automatic page layout detection
 - User can manually define and adjust recognition regions
 - Import images from disk, scanning devices, clipboard and screenshots
 - Supports multipage PDF documents
 - Recognized text displayed directly next to the image
 - Editing of output text, including search/replace and removing line breaks
 - Spellchecking for output text (if corresponding dictionary installed)
This package contains the Qt front-end.
%endif

%package common
Group: Office
Summary: Common files for %name
BuildArch: noarch
Conflicts: %name < 3.1.2

%description common
Common files for %name.

%prep
%setup
%patch1 -p2
%patch2 -p2

%build
%cmake -DINTERFACE_TYPE=gtk -DENABLE_VERSIONCHECK=0 -DMANUAL_DIR="%_docdir/%name-common"
%cmake_build
mv BUILD build-gtk

%if_with qt4
%cmake -DINTERFACE_TYPE=qt4 -DENABLE_VERSIONCHECK=0 -DMANUAL_DIR="%_docdir/%name-common"
%cmake_build
mv BUILD build-qt4
%endif

%cmake -DINTERFACE_TYPE=qt5 -DENABLE_VERSIONCHECK=0 -DMANUAL_DIR="%_docdir/%name-common"
%cmake_build
mv BUILD build-qt5

%install
rm -rf BUILD
cp -al build-gtk BUILD
%cmakeinstall_std

%if_with qt4
rm -rf BUILD
cp -al build-qt4 BUILD
%cmakeinstall_std
%endif

rm -rf BUILD
cp -al build-qt5 BUILD
%cmakeinstall_std

%find_lang %name

# make link to old base command
ln -s %name-gtk %buildroot%_bindir/%name


%files common -f %name.lang
%doc COPYING
%doc AUTHORS ChangeLog NEWS README TODO
%_iconsdir/hicolor/48x48/apps/%name.png
%_iconsdir/hicolor/128x128/apps/%name.png
%_iconsdir/hicolor/256x256/apps/%name.png
%doc %_docdir/%name-common/manual*.html

%files gtk
%_bindir/%name-gtk
%_datadir/appdata/%name-gtk.appdata.xml
%_desktopdir/%name-gtk.desktop
%_datadir/glib-2.0/schemas/org.gnome.%name.gschema.xml

%if_with qt4
%files qt4
%_bindir/%name-qt4
%_datadir/appdata/%name-qt4.appdata.xml
%_desktopdir/%name-qt4.desktop
%endif

%files qt5
%_bindir/%name-qt5
%_datadir/appdata/%name-qt5.appdata.xml
%_desktopdir/%name-qt5.desktop

%files
%_bindir/%name

%changelog
