%define ver_major 2.8
%define oldver 2.0

Name: gimp
Version: %ver_major.20
Release: alt0.M80P.1

Summary: The GNU Image Manipulation Program
License: GPLv3, LGPL
Group: Graphics
Url: http://www.gimp.org/

Packager: Valery Inozemtsev <shrek@altlinux.ru>

Obsoletes: gimp2 < %version-%release
Provides: gimp2 = %version-%release
Conflicts: gimp2-perl create-resources <= 0.1.3-alt1
Requires: lib%name = %version-%release libgegl >= 0.2.0
Requires: icc-profiles

Source: %name-%version.tar
Patch: %name-%version-%release.patch

BuildRequires: bzlib-devel gcc-c++ gtk-doc iso-codes-devel intltool libXmu-devel libXpm-devel libalsa-devel libart_lgpl-devel
BuildRequires: libexif-devel libexpat-devel libfreetype-devel libgtkhtml2-devel libjpeg-devel liblcms2-devel libmng-devel
BuildRequires: libpng-devel librsvg-devel libtiff-devel libwmf-devel perl-XML-Parser xml-utils xsltproc libpoppler-glib-devel
BuildRequires: libcurl-devel libdbus-glib-devel gvfs-devel libXext-devel python-dev python-module-pygtk-devel libgio-devel
BuildRequires: libwebkitgtk2-devel libbabl-devel libgegl-devel libjasper-devel libgudev-devel libXcursor-devel libgs-devel

%description
The GIMP (GNU Image Manipulation Program) is a powerful image
composition and editing program, which can be extremely useful for
creating logos and other graphics for Web pages.  The GIMP has many of
the tools and filters you would expect to find in similar commercial
offerings, and some interesting extras as well. The GIMP provides a
large image manipulation toolbox, including channel operations and
layers, effects, sub-pixel imaging and anti-aliasing, and conversions,
all with multi-level undo.

%package -n lib%name
Summary: GIMP libraries
Group: System/Libraries
License: LGPL
Obsoletes: libgimp2 < %version-%release
Provides: libgimp2 = %version-%release

%description -n lib%name
Libraries used to communicate between The GIMP and other programs which
may function as "GIMP plugins".

%package -n lib%name-devel
Summary: GIMP plugin and extension development kit
Group: Graphics
Requires: lib%name = %version-%release
Obsoletes: libgimp2-devel < %version-%release
Provides: libgimp2-devel = %version-%release

%description -n lib%name-devel
Development libraries and header files for writing GIMP plugins and extensions.

%add_python_lib_path %_libdir/%name/%oldver/python

%prep
%setup -q
%patch -p1

%build
gtkdocize
%autoreconf
%configure \
	--with-gimpdir=".config/%name-%ver_major" \
	--enable-gtk-doc \
	--disable-gimp-console \
	--with-poppler \
	--enable-python

%make_build

%install
%make DESTDIR=%buildroot install

find %buildroot%_libdir/%name -name \*.la -delete

# Execute find_lang for all components and merge the resulting lists
%find_lang --output=global.lang gimp20 gimp20-libgimp gimp20-std-plug-ins gimp20-script-fu gimp20-tips gimp20-python

%files -f global.lang
%doc AUTHORS NEWS README README.i18n
%dir %_sysconfdir/%name
%dir %_sysconfdir/%name/%oldver
%config %_sysconfdir/%name/%oldver/*
%_bindir/%name
%_bindir/%name-*
%dir %_libdir/%name
%dir %_libdir/%name/%oldver
%_libdir/%name/%oldver/modules
%_libdir/%name/%oldver/plug-ins
%_libdir/%name/%oldver/environ
%_libdir/%name/%oldver/interpreters
%_libdir/%name/%oldver/python
%_datadir/%name
%_datadir/appdata/%name.appdata.xml
%_iconsdir/hicolor/*/apps/*
%_desktopdir/%name.desktop
%_man1dir/*
%_man5dir/*

%files -n lib%name
%_libdir/*.so.*

%files -n lib%name-devel
%_datadir/gtk-doc/html/*
%_includedir/*
%_bindir/gimptool*
%_libdir/*.so
%_pkgconfigdir/*.pc
%_datadir/aclocal/*

%changelog
