Name: git
Version: 2.24.1
Release: alt1

Summary: Git core and tools
License: GPLv2
Group: Development/Other
Url: https://git-scm.com/

# git://git.altlinux.org/gears/g/git.git
Source: %name-%version-%release.tar

%def_enable curl
%def_enable expat
%def_with arch
%def_with cvs
%def_with email
%def_with tk
%def_with gui
%def_with doc
%def_with gitweb
%def_without python
%def_with svn

# List of architectures worthy of running the test suite.
%define check_arches x86_64 %ix86
%ifarch %check_arches
%def_with check
%else
%def_without check
%endif

%define _libexecdir /usr/libexec
%define gitexecdir %_libexecdir/git-core
%define pkgdocdir %_docdir/%name

Requires: %name-core = %EVR, perl-Git = %EVR

BuildRequires: hardlink, libssl-devel, perl-devel, perl-podlators, perl(Error.pm), zlib-devel >= 0:1.2
%{!?_without_python:BuildRequires: python-modules-encodings >= 0:2.4}
%{!?_without_cvs:BuildRequires: cvs perl(DBI.pm)}
%{!?_disable_curl:BuildRequires: libcurl-devel}
%{!?_disable_expat:BuildRequires: libexpat-devel}
%{!?_without_email:BuildRequires: perl(Mail/Address.pm) perl(Net/SMTP/SSL.pm) perl(Term/ReadLine.pm)}
%{!?_without_svn:BuildRequires: perl(Encode.pm) perl(Memoize.pm) perl(SVN/Core.pm) perl(Term/ReadKey.pm) perl(YAML/Any.pm) subversion subversion-server-common}
%{!?_without_doc:BuildRequires: asciidoc > 0:6.0.3, xmlto}
%{?!_without_gitweb:BuildRequires: perl(charnames.pm) perl(CGI.pm) perl(Encode.pm)}
%{?!_without_check:%{?!_disable_check:BuildRequires: cvsps gnupg perl(HTTP/Date.pm) perl(Term/ANSIColor.pm) perl(DBD/SQLite.pm) perl(Encode/JP.pm) unzip}}

%description
Git is a fast, scalable, distributed revision control system with an
unusually rich command set that provides both high-level operations
and full access to internals.

%package core
Summary: Git core tools
Group: Development/Other
Requires: diffstat less openssh-clients rsync
# due to git commit --fast.
Provides: git-commit-fast

%description core
Git is a fast, scalable, distributed revision control system with an
unusually rich command set that provides both high-level operations
and full access to internals.

This package contains core set of Git tools with minimal dependencies.

%package server
Summary: Simple TCP git server for git repositories
Group: System/Servers
Requires: %name-core = %EVR

%description server
Git is a fast, scalable, distributed revision control system with an
unusually rich command set that provides both high-level operations
and full access to internals.

This package contains git server that normally listens on TCP port 9418.
It waits for a connection, and will just execute "git-upload-pack"
when it gets one.  It is ideally suited for read-only updates, i.e.,
pulling from git repositories.

%package arch
Summary: Git tools for importing Arch repositories
Group: Development/Other
BuildArch: noarch
Requires: %name-core = %EVR, tla

%description arch
Git is a fast, scalable, distributed revision control system with an
unusually rich command set that provides both high-level operations
and full access to internals.

This package contains Git tools for importing Arch repositories.

%package cvs
Summary: Git tools for importing CVS repositories
Group: Development/Other
BuildArch: noarch
Requires: %name-core = %EVR, perl-Git = %EVR, cvs, cvsps

%description cvs
Git is a fast, scalable, distributed revision control system with an
unusually rich command set that provides both high-level operations
and full access to internals.

This package contains Git tools for importing CVS repositories.

%package -n perl-Git
Summary: Perl interface to Git
Group: Development/Perl
BuildArch: noarch
Requires: %name-core = %EVR

%description -n perl-Git
Git is a fast, scalable, distributed revision control system with an
unusually rich command set that provides both high-level operations
and full access to internals.

This package contains Perl interface to Git.

%package email
Summary: Git tools for sending email
Group: Development/Other
BuildArch: noarch
Requires: perl-Git = %EVR
# Workaround for ALT#23407.
Requires: perl(MIME/Base64.pm) perl(Authen/SASL.pm)

%description email
Git is a fast, scalable, distributed revision control system with an
unusually rich command set that provides both high-level operations
and full access to internals.

This package contains Git tools for sending email.

%package svn
Summary: Git tools for importing Subversion repositories
Group: Development/Other
Requires: %name-core = %EVR, perl-Git = %EVR, subversion

%description svn
Git is a fast, scalable, distributed revision control system with an
unusually rich command set that provides both high-level operations
and full access to internals.

This package contains Git tools for importing Subversion repositories.

%package -n gitk
Summary: Git revision tree visualiser ('gitk')
Group: Development/Other
BuildArch: noarch
Requires: %name-core = %EVR, tk >= 8.4

%description -n gitk
Git is a fast, scalable, distributed revision control system with an
unusually rich command set that provides both high-level operations
and full access to internals.

This package contains Git revision tree visualiser ('gitk').

%package gui
Summary: Git GUI tool
Group: Development/Other
BuildArch: noarch
Requires: %name-core = %EVR, tk >= 8.4

%description gui
Git is a fast, scalable, distributed revision control system with an
unusually rich command set that provides both high-level operations
and full access to internals.

This package contains Git GUI tool.

%package -n gitweb
Summary: Git web interface
Group: Development/Other
BuildArch: noarch
Requires: %name-core = %EVR
Requires: perl(charnames.pm)

%description -n gitweb
Git is a fast, scalable, distributed revision control system with an
unusually rich command set that provides both high-level operations
and full access to internals.

This package contains simple web interface to track changes in Git
repositories.

%package -n libgit-devel
Summary: Git develpoment library and header files
Group: Development/C

%description -n libgit-devel
Git is a fast, scalable, distributed revision control system with an
unusually rich command set that provides both high-level operations
and full access to internals.

This package contains libgit.a develpoment library and accompanying
header files.

%package doc
Summary: Git documentation
Group: Development/Documentation
BuildArch: noarch
Provides: %name-docs = %EVR
Obsoletes: %name-docs

%description doc
Git is a fast, scalable, distributed revision control system with an
unusually rich command set that provides both high-level operations
and full access to internals.

This package contains the Git documentation in text and HTML formats.

%package contrib
Summary: Git contrib files
Group: Development/Other
BuildArch: noarch
AutoReq: no
Requires: %name-core = %EVR

%description contrib
Git is a fast, scalable, distributed revision control system with an
unusually rich command set that provides both high-level operations
and full access to internals.

This package contains Git contributed software.

%package diff-highlight
Summary: Utility that highlights changes in diffs
Group: Development/Other
BuildArch: noarch
Requires: %name-core = %EVR

%description diff-highlight
Git is a fast, scalable, distributed revision control system with an
unusually rich command set that provides both high-level operations
and full access to internals.

This package contains diff-highlight utility, which is a part of Git
contributed software.

%package subtree
Summary: Merge subtrees together and split repository into subtrees
Group: Development/Other
BuildArch: noarch
Requires: %name-core = %EVR

%description subtree
Git is a fast, scalable, distributed revision control system with an
unusually rich command set that provides both high-level operations
and full access to internals.

This package contains git-subtree utility which is a part of Git
contributed software.

%package full
Summary: Git core and tools
Group: Development/Other
BuildArch: noarch
Requires: %name-core = %EVR, perl-Git = %EVR, %name-server = %EVR
%{!?_without_arch:Requires: %name-arch = %EVR}
%{!?_without_cvs:Requires: %name-cvs = %EVR}
%{!?_without_email:Requires: %name-email = %EVR}
%{!?_without_svn:Requires: %name-svn = %EVR}
%{!?_without_tk:Requires: gitk = %EVR}
%{!?_without_gui:Requires: %name-gui = %EVR}
%{!?_without_doc:Requires: %name-doc = %EVR}
%{!?_without_gitweb:Requires: gitweb = %EVR}

%description full
Git is a fast, scalable, distributed revision control system with an
unusually rich command set that provides both high-level operations
and full access to internals.

This package contains the full set of Git tools.

%prep
%setup -n %name-%version-%release
rm -r perl/Git/LoadCPAN*
cat >config.mak <<'EOF'
V = 1
CFLAGS = %optflags
NO_GETTEXT = 1
GNU_ROFF = 1
ETC_GITCONFIG = /etc/gitconfig
prefix = %_prefix
libdir = %_libdir
mandir = %_mandir
htmldir = %pkgdocdir
NO_PERL_CPAN_FALLBACKS = 1
%{?_disable_curl:NO_CURL = 1}
%{?_disable_expat:NO_EXPAT = 1}
%{?_without_python:NO_PYTHON = 1}
%{?_without_python:SCRIPT_PYTHON_INS = }
EOF

%build
touch git-gui/credits
%make_build -C Documentation doc.dep
%make_build all %{!?_without_doc:man html}
%make_build -C contrib/diff-highlight
%make_build -C contrib/subtree all %{!?_without_doc:doc}

%check
%{?_without_email:rm t/t9001-send-email.sh}
%make_build -k test

%install
%makeinstall_std \
	install-lib \
	%{!?_without_doc:install-man install-html}
%makeinstall_std %{!?_without_doc:install-doc} -C contrib/subtree

mkdir -p %buildroot%_includedir/git
find -name \*.d -print0 |
	xargs -0 sed -n 's/^\([^:[:space:]]*\.h\)[[:space:]]*:.*/\1/p' -- |
	sort -u |
	xargs realpath -e --relative-to=. -- |
	sort -u > headers.list
tr / '\n' < headers.list |
	grep -Fv .h |
	sort -u |
	xargs -i ln -s . %buildroot%_includedir/git/'{}'
xargs install -pm644 -t %buildroot%_includedir/git -- < headers.list

chmod a-x %buildroot%gitexecdir/git-sh-setup
install -pDm644 contrib/completion/git-completion.bash \
	%buildroot%_datadir/bash-completion/completions/git
# Generate shell functions provides list.
(
	echo '# shell functions provides list'
	sed -n 's/^\([A-Za-z][A-Za-z_0-9]*\)[[:space:]]*().*/\1/pg' \
		%buildroot%gitexecdir/git-sh-setup |
		LC_COLLATE=C sort -u
) > %buildroot%gitexecdir/.provides.sh

# git-server.
mkdir -p %buildroot%_sbindir
mv %buildroot%gitexecdir/git-daemon %buildroot%_sbindir/
install -pD -m640 git.xinetd \
	%buildroot%_sysconfdir/xinetd.d/git

# Fix manpages.
find %buildroot%_mandir -type f -print0 |
	xargs -r0 grep -lZ '^.\+\.sp$' -- |
	xargs -r0 sed -i 's/^\(.\+\)\(\.sp\)$/\1\n\2/' --

find %buildroot%_datadir/git-core/ -name '*watchman*' -delete -print

# Install docs and contrib.
mkdir -p %buildroot%pkgdocdir/
install -pm644 Documentation/SubmittingPatches %buildroot%pkgdocdir/
install -Dm755 contrib/diff-highlight/diff-highlight %buildroot%_bindir
cp -a contrib %buildroot%_datadir/git-core/
rm -r %buildroot%_datadir/git-core/contrib/completion
rm -r %buildroot%_datadir/git-core/contrib/emacs
rm -r %buildroot%_datadir/git-core/contrib/examples
rm -r %buildroot%_datadir/git-core/contrib/diff-highlight
rm -r %buildroot%_datadir/git-core/contrib/subtree

# Remove unpackaged files.
%{?_without_arch:rm %buildroot%gitexecdir/git-archimport}
%{?_without_email:rm %buildroot%gitexecdir/git-*email*}
%{?_without_svn:rm %buildroot%gitexecdir/git-*svn*}

# Relocate hooks, convert template hooks to symlinks.
pushd %buildroot%_datadir/git-core/templates/hooks
	mkdir ../../hooks
	for f in *.sample; do
		mv $f ../../hooks/${f%%.sample}
		ln -s %_datadir/git-core/hooks/${f%%.sample} $f
	done
popd

# Avoid compressing templates.
%set_compress_topdir %_mandir

# Hardlink identical files together.
%define __spec_install_custom_post  hardlink -vc %buildroot

%pre server
/usr/sbin/groupadd -r -f _gitd
/usr/sbin/useradd -r -g _gitd -d /dev/null -s /dev/null -c 'The git server' -n _gitd >/dev/null 2>&1 ||:

%files

%files full

%files core
%_datadir/bash-completion/completions/git
%_bindir/*
%exclude %_bindir/git-cvs*
%gitexecdir/
%exclude %gitexecdir/git-cvs*
%exclude %gitexecdir/git-gui*
%exclude %gitexecdir/git-citool
%exclude %gitexecdir/git-add--interactive
%exclude %gitexecdir/git-subtree
%exclude %_bindir/gitk
%exclude %_bindir/diff-highlight
%exclude %_bindir/diff-highlight
%{!?_without_arch:%exclude %gitexecdir/git-archimport}
%{!?_without_email:%exclude %gitexecdir/git-*email*}
%{!?_without_svn:%exclude %gitexecdir/*svn*}
%_datadir/git-core/
%exclude %_datadir/git-core/contrib/
%if_with doc
%_mandir/man?/*
%exclude %_man1dir/git-subtree.*
%exclude %_man1dir/git-daemon.*
%exclude %_man1dir/git-svn*.1*
%exclude %_man1dir/git-cvs*.1*
%exclude %_man1dir/git-archimport.1*
%exclude %_man1dir/git-*email*.1*
%exclude %_man1dir/gitk*.1*
%exclude %_man3dir/Git.3*
%exclude %_mandir/man?/gitweb.*
%endif #doc

%files server
%_sbindir/git-daemon
%if_with doc
%_man1dir/git-daemon.*
%endif #doc
%attr(640,root,wheel) %config(noreplace) %_sysconfdir/xinetd.d/git

%if_with arch
%files arch
%gitexecdir/git-archimport
%if_with doc
%_man1dir/git-archimport.1*
%endif #doc
%endif #arch

%if_with cvs
%files cvs
%_bindir/*cvs*
%gitexecdir/*cvs*
%if_with doc
%_man1dir/git-cvs*.1*
%endif #doc
%endif #cvs

%files -n perl-Git
%gitexecdir/git-add--interactive
%if_with doc
%_man3dir/Git.3*
%endif
%perl_vendor_privlib/Git/
%perl_vendor_privlib/Git.pm
%exclude %perl_vendor_privlib/Git/SVN*

%if_with email
%files email
%gitexecdir/*email*
%if_with doc
%_man1dir/git-*email*.1*
%endif #doc
%endif #email

%if_with svn
%files svn
%gitexecdir/*svn*
%if_with doc
%_man1dir/git-svn*.1*
%endif #doc
%perl_vendor_privlib/Git/SVN*
%endif #svn

%if_with tk
%files -n gitk
%_bindir/gitk
%_datadir/gitk/
%if_with doc
%_man1dir/gitk.1*
%endif #doc
%endif #tk

%if_with gui
%files gui
%gitexecdir/git-gui*
%gitexecdir/git-citool
%_datadir/git-gui/
%if_with doc
# Not Yet...
# %_man1dir/git-gui.1*
# %_man1dir/git-citool.1*
%endif #doc
%endif #gui

%if_with gitweb
%files -n gitweb
%_datadir/gitweb/
%if_with doc
%_mandir/man?/gitweb.*
%endif #doc
%endif #gitweb

%files -n libgit-devel
%exclude %_libdir/common-main.o
%_libdir/lib*
%_includedir/*

%files doc
%pkgdocdir/

%files contrib
%dir %_datadir/git-core/
%_datadir/git-core/contrib/

%files diff-highlight
%_bindir/diff-highlight
%doc contrib/diff-highlight/README

%files subtree
%gitexecdir/git-subtree
%if_with doc
%_man1dir/git-subtree.*
%endif #doc

%changelog
