%def_disable snapshot
%define ver_major 3.24
%define api_ver 1.0
%def_enable python

Name: gitg
Version: %ver_major.0
Release: alt0.M80P.1

Summary: git repository viewer targeting gtk+/GNOME
Group: Development/Other
License: GPL
Url: https://wiki.gnome.org/Apps/Gitg

%if_disabled snapshot
Source: ftp://ftp.gnome.org/pub/gnome/sources/%name/%ver_major/%name-%version.tar.xz
%else
Source: %name-%version.tar
%endif
# hack to avoid break of non-SMP build
Patch: gitg-3.18.0-alt-makefile.patch

PreReq: lib%name = %version-%release
# gitg/gitg-plugins-engine.vala: repo.require("PeasGtk", "1.0", 0);
Requires: typelib(PeasGtk)

%define gitg_pluginsdir %_libdir/%name/plugins

%if_enabled python
# use python3
AutoReqProv: nopython
%define __python %nil
%endif

%define glib_ver 2.38
%define gtk_ver 3.20
%define gtksourceview_ver 3.10
%define git2_ver 0.25.0
%define webkit_ver 2.6.0
%define gtkspell_ver 3.0.3
%define peas_ver 1.5.0

BuildPreReq: libgio-devel >= %glib_ver
BuildPreReq: libgtk+3-devel >= %gtk_ver
BuildPreReq: libgit2-glib-devel >= %git2_ver
BuildPreReq: libgtksourceview3-devel >= %gtksourceview_ver
BuildPreReq: libwebkit2gtk-devel >= %webkit_ver
BuildPreReq: libgtkspell3-devel >= %gtkspell_ver
BuildPreReq: libpeas-devel >= %peas_ver
BuildRequires: gnome-common intltool desktop-file-utils
BuildRequires: libgee0.8-devel libjson-glib-devel libsecret-devel
BuildRequires: gobject-introspection-devel libgtk+3-gir-devel libxml2-devel
BuildRequires: libgit2-glib-gir-devel libwebkit2gtk-gir-devel libgee0.8-gir-devel
BuildRequires: vala-tools
BuildRequires: gsettings-desktop-schemas-devel
%{?_enable_python:BuildRequires: python3-devel rpm-build-python3 python3-module-pygobject3-devel}

%description
Gitg is a graphical user interface for git. It aims at being a small,
fast and convenient tool to visualize the history of git repositories.
Besides visualization, gitg also provides several utilities to manage your
repository and commit your work.

%package -n lib%name
Summary: lib%name library
Group: System/Libraries

%description -n lib%name
Gitg is a graphical user interface for git. It aims at being a small,
fast and convenient tool to visualize the history of git repositories.
Besides visualization, gitg also provides several utilities to manage your
repository and commit your work.

This package provides shared Gitg library.

%package -n lib%name-devel
Summary: Development files for lib%name
Group: Development/C
PreReq: lib%name = %version-%release

%description -n lib%name-devel
Gitg is a graphical user interface for git. It aims at being a small,
fast and convenient tool to visualize the history of git repositories.
Besides visualization, gitg also provides several utilities to manage your
repository and commit your work.

This package provides headers and libraries to develop plugins for Gitg
or other applications

%package -n lib%name-gir
Summary: GObject introspection data for the Gitg library
Group: System/Libraries
Requires: lib%name = %version-%release

%description -n lib%name-gir
This package provides GObject introspection data for the Gitg
library.

%package -n lib%name-gir-devel
Summary: GObject introspection devel data for the Gitg library
Group: Development/Other
BuildArch: noarch
Requires: lib%name-gir = %version-%release
Requires: lib%name-devel = %version-%release

%description -n lib%name-gir-devel
This package provides GObject introspection devel data for the Gitg
library.

%prep
%setup
%patch

%build
%autoreconf
%configure --disable-static \
	%{subst_enable python}
%make

%install
%makeinstall_std
%find_lang %name
desktop-file-install --dir %buildroot%_desktopdir \
	--add-category=RevisionControl \
	%buildroot%_desktopdir/gitg.desktop

%check
%make check

%files -f %name.lang
%_bindir/%name
%gitg_pluginsdir/
%_datadir/glib-2.0/schemas/org.gnome.gitg.gschema.xml
%_desktopdir/%name.desktop
%_datadir/%name/
%_man1dir/%{name}*
%_iconsdir/hicolor/*x*/apps/*
%_iconsdir/hicolor/scalable/apps/%name-symbolic.svg
%_datadir/appdata/%name.appdata.xml
%{?_enable_python:%python3_sitelibdir/gi/overrides/*}
%doc AUTHORS NEWS README

%exclude %gitg_pluginsdir/*.la

%files -n lib%name
%_libdir/lib%name-%api_ver.so.*
%_libdir/lib%name-ext-%api_ver.so.*

%files -n lib%name-devel
%_includedir/lib%name-%api_ver/
%_includedir/lib%name-ext-%api_ver/
%_libdir/lib%name-%api_ver.so
%_libdir/lib%name-ext-%api_ver.so
%_libdir/pkgconfig/lib%name-%api_ver.pc
%_libdir/pkgconfig/lib%name-ext-%api_ver.pc
%_vapidir/lib%name-%api_ver.vapi
%_vapidir/lib%name-ext-1.0.vapi

%files -n lib%name-gir
%_typelibdir/Gitg-%api_ver.typelib
%_typelibdir/GitgExt-%api_ver.typelib

%files -n lib%name-gir-devel
%_girdir/Gitg-%api_ver.gir
%_girdir/GitgExt-%api_ver.gir

%changelog
