Name: gkrellm
Version: 2.3.5
Release: alt3
Packager: Roman Savochenko <rom_as at altlinux.ru>

Summary: Multiple stacked system monitors
License: GPLv3+
Group: Monitoring
Url: http://gkrellm.net/

Source0: %name-%version.tar
Source1: gkrellm_16.xpm
Source2: gkrellm_32.xpm
Source3: gkrellm_48.xpm
Source4: gkrellm-2.3.1-alt-init
Source5: gkrellm-2.2.8-alt-sysconfig
Patch0: %name-%version-aticonfig.patch
Patch1: UK_RU_translation.patch
Patch2: gkrellm-2.3.5-build.patch

# for gkrellm >= 2.2.0
Requires: libgtk+2 >= 2.3.1

BuildPreReq: libSM-devel libgtk+2-devel libntlm-devel libsensors3-devel libssl-devel

%description
GKrellM charts SMP CPU, load, Disk, and all active net interfaces
automatically. An on/off button and online timer for the PPP interface
is provided. Monitors for memory and swap usage, file system, internet
connections, APM laptop battery, mbox style mailboxes, and cpu temps.
Also includes an uptime monitor, a hostname label, and a clock/calendar.
Additional features are:

  * Autoscaling grid lines with configurable grid line resolution.
  * LED indicators for the net interfaces.
  * A gui popup for configuration of chart sizes and resolutions.

%package devel
Summary: Gkrellm include files
Group: Development/Other
Requires: %name = %version

%description devel
Gkrellm header files for gkrellm development and plugin support.

%package -n gkrellmd
Summary: Gkrellm server
Group: Monitoring

%description -n gkrellmd
Gkrellm server allows connections from Gkrellm clients over network.

%prep
%setup
%patch0 -p2
%patch1 -p1
%patch2 -p1

subst 's|^FLAGS = \(.*\)|FLAGS = %optflags \1|' src/Makefile

# gkrellmd tuning
subst 's,^#allow-host\tlocalhost,allow-host	localhost,g' server/gkrellmd.conf
subst 's,^max-clients.*,max-clients 5,g' server/gkrellmd.conf
subst 's,^update-hz.*,update-hz 2,g' server/gkrellmd.conf

# set platform-dependent libdir
subst 's,/usr/lib,%_libdir,g' src/gkrellm.h server/gkrellmd.h

%build
%make_build enable_nls=1 \
	INSTALLROOT=%prefix \
	SMC_LIBS='-L%_x11libdir -lSM -lICE'
#SYS_LIBS=-L%_x11libdir

%install
mkdir -p %buildroot%_bindir
mkdir -p %buildroot%_libdir/gkrellm2/plugins
mkdir -p %buildroot%_desktopdir

%make_install install enable_nls=1 \
	INSTALLROOT=%buildroot%prefix \
	PKGCONFIGDIR=%buildroot%_pkgconfigdir

mkdir -p %buildroot%_niconsdir
mkdir -p %buildroot%_liconsdir
mkdir -p %buildroot%_miconsdir

install -m 644 %SOURCE2 %buildroot%_niconsdir/gkrellm.xpm
install -m 644 %SOURCE3 %buildroot%_liconsdir/gkrellm.xpm
install -m 644 %SOURCE1 %buildroot%_miconsdir/gkrellm.xpm

install -D -m755 %SOURCE4 %buildroot%_initdir/gkrellmd
install -D -m644 %SOURCE5 %buildroot%_sysconfdir/sysconfig/gkrellmd
install -D -m644 server/gkrellmd.conf %buildroot%_sysconfdir/gkrellmd.conf

cat > %buildroot%_desktopdir/%name.desktop << __EOF__
[Desktop Entry]
Version=1.0
Type=Application
Name=Gkrellm
Exec=%name
Icon=%name
Categories=System;Monitor;
Comment=A gtk-based monitoring app
__EOF__

%find_lang %name

%pre -n gkrellmd
/usr/sbin/useradd -M -r -d /dev/null -s /dev/null \
	-c "GKrellM server" gkrellmd >/dev/null 2>&1 || :

%post -n gkrellmd
%post_service gkrellmd
%preun -n gkrellmd
%preun_service gkrellmd

%files -f %name.lang
%doc COPYRIGHT Changelog CREDITS README *.html
%_bindir/gkrellm
%_desktopdir/*
%_man1dir/gkrellm.*
%dir %_libdir/gkrellm2
%_libdir/gkrellm2/*
%_niconsdir/gkrellm.xpm
%_liconsdir/gkrellm.xpm
%_miconsdir/gkrellm.xpm

%files devel
%dir %_includedir/gkrellm2
%_includedir/gkrellm2/*
%_libdir/pkgconfig/*

%files -n gkrellmd
%_bindir/gkrellmd
%config(noreplace) %_initdir/gkrellmd
%config(noreplace) %_sysconfdir/sysconfig/gkrellmd
%config(noreplace) %_sysconfdir/gkrellmd.conf
%_man1dir/gkrellmd.*


%changelog
