%def_enable snapshot

%define ver_major 2.50
%define _libexecdir %_prefix/libexec
%def_enable installed_tests
%def_with libproxy

Name: glib-networking
Version: %ver_major.0
Release: alt1.M80P.1

Summary: Networking support for GIO
Group: System/Libraries
License: LGPLv2+
Url: http://www.gnome.org

%if_disabled snapshot
Source: ftp://ftp.gnome.org/pub/gnome/sources/%name/%ver_major/%name-%version.tar.xz
%else
Source: %name-%version.tar
%endif

Requires: ca-certificates gsettings-desktop-schemas >= 3.2.0

%define glib_ver 2.46.0
%define gnutls_ver 2.12.8
%define p11kit_ver 0.8
%define libproxy_ver 0.3.1

BuildRequires: libgio-devel >= %glib_ver
BuildRequires: libgnutls-devel >= %gnutls_ver libgcrypt-devel
BuildRequires: libp11-kit-devel >= %p11kit_ver ca-certificates
BuildRequires: gsettings-desktop-schemas-devel
%{?_with_libproxy:BuildRequires: libproxy-devel >= %libproxy_ver}

%description
This package contains modules that extend the networking support in GIO.
In particular, it contains a libproxy-based GProxyResolver implementation
and a gnutls-based GTlsConnection implementation.

%package tests
Summary: Tests for the %name package
Group: Development/Other
Requires: %name = %version-%release

%description tests
This package provides tests programs that can be used to verify
the functionality of the installed %name package.


%prep
%setup
%ifarch e2k
sed -i 's,-Werror=missing-include-dirs,,' configure*
%endif

%build
%autoreconf
%configure \
	--disable-static \
	%{subst_with libproxy} \
	%{?_enable_installed_tests:--enable-installed-tests} \
	--with-ca-certificates=%_datadir/ca-certificates/ca-bundle.crt

%make_build

%install
%makeinstall_std

%find_lang %name

%check
#%%make check

%files -f %name.lang
%_libdir/gio/modules/libgiognutls.so
%_libdir/gio/modules/libgiognomeproxy.so
%if_with libproxy
%_libdir/gio/modules/libgiolibproxy.so
%_libexecdir/glib-pacrunner
%_datadir/dbus-1/services/org.gtk.GLib.PACRunner.service
%_prefix/lib/systemd/user/glib-pacrunner.service
%endif
%doc NEWS README

%exclude %_libdir/gio/modules/*.la

%if_enabled installed_tests
%files tests
%_libexecdir/installed-tests/%name/
%_datadir/installed-tests/%name/
%endif

%changelog
