%define kernel_base_version 4.4
%define kernel_source kernel-source-%kernel_base_version

Name: glibc-kernheaders
Version: %kernel_base_version
Release: alt1

Summary: Linux kernel C header files for use by glibc and other userspace software
License: GPLv2
Group: Development/Kernel
Url: http://www.kernel.org/

# git://git.altlinux.org/gears/g/%name.git
Patch: %name-%version-%release.patch

Patch2: 0001-Use-__u8-from-linux-types.h.patch

BuildRequires: rpm-build-kernel
BuildRequires: %kernel_source = 1.0.0

Provides: kernel-headers = %version-%release
Provides: linux-libc-headers = %version-%release
Obsoletes: linux-libc-headers < %version

%define base_arch %_target_cpu
%ifarch %ix86 x86_32 x86_64
%define base_arch x86
%endif
%ifarch %arm
%define base_arch arm
%endif
%ifarch aarch64
%define base_arch arm64
%endif
%ifarch ppc ppc64
%define base_arch powerpc
%endif

%description
This package includes the C header files that specify the interface
between the Linux kernel and userspace libraries and programs.
The header files define structures and constants that are needed for
building most standard programs and are also needed to build glibc.

%prep
%setup -cT
tar -xf %kernel_src/%kernel_source.tar
cd %kernel_source
%patch -p1
%patch2 -p1

%install
%define hdr_dir %_includedir/linux-default
make -C %kernel_source headers_install_all \
	INSTALL_HDR_PATH=%buildroot%hdr_dir \
	HDR_ARCH_LIST="%base_arch"
find %buildroot%_includedir -name "*.install*" -delete
ln -snf asm-%base_arch %buildroot%hdr_dir/include/asm
[ "%base_arch" = "%_target_cpu" ] ||
	ln -snf asm-%base_arch %buildroot%hdr_dir/include/asm-%_target_cpu

%check
set +x
d="$PWD"
cd %buildroot%hdr_dir/include
for f in {linux,asm}/*.h; do
	printf '#include <%%s>\n' "$f" |
		%__cc %optflags -S -I"$PWD" -o/dev/null -xc - ||
			echo "$f"
done > "$d"/fail.list
if [ -s "$d"/fail.list ]; then
	echo "Compilation check failed for $(grep -Fc .h -- "$d"/fail.list) files:"
	cat -- "$d"/fail.list
fi
cd - > /dev/null

%pre
for d in %hdr_dir/include/asm-%_target_cpu; do
	[ -d "$d" -a ! -L "$d" ] || continue
	rmdir "$d" 2> /dev/null ||:
done

%files
%hdr_dir

%changelog
