%define installdir %webserver_webappsdir/%name


Name: glpi
Version: 0.85.4
Release: alt1


Summary: IT and asset management software
License: GPLv2
Group: Networking/Other


URL: http://www.glpi-project.org
Packager: Pavel Zilke <zidex at altlinux dot org>
BuildArch: noarch

Source0: http://www.glpi-project.org/IMG/gz/%name-%version.tar.gz
Source1: apache.conf
Source2: apache2.conf
Source3: README.ALT
Patch: patch0.patch

Requires: webserver-common php-engine curl lynx
BuildRequires(pre): rpm-macros-webserver-common

%description
GLPI is the Information Resource-Manager with an additional Administration-
Interface.
You can use it to build up a database with an inventory for your company
(computer, software, printers...).
It has enhanced functions to make the daily life for the administrators easier,
like a job-tracking-system with mail-notification and methods to build a
database with basic information about your network-topology.


%package apache
Summary: Apache 1.x web-server configuration for %name
Group: Networking/Other
Requires: %name = %version-%release, apache
%description apache
Apache 1.x web-server configuration for %name


%package apache2
Summary: Apache 2.x web-server configuration for %name
Group: Networking/Other
Requires: %name = %version-%release, apache2
%description apache2
Apache 2.x web-server configuration for %name


%package php5
Summary: PHP5 dependencies for %name
Group: Networking/Other
Requires: %name = %version-%release, php5-mysql, php5-ldap, php5-imap, php5-curl, php5-gd2
%description php5
PHP5 dependencies for %name


%prep
%setup

%patch -p0


%build

%install
# install apache config
install -pD -m0644 %_sourcedir/apache.conf %buildroot%_sysconfdir/httpd/conf/addon-modules.d/%name.conf
install -pD -m0644 %_sourcedir/apache2.conf %buildroot%_sysconfdir/httpd2/conf/addon.d/A.%name.conf

# install glpi
mkdir -p %buildroot%installdir
cp -rp * %buildroot%installdir/

#install README.ALT
install -pD -m0644 %_sourcedir/README.ALT README.ALT

# remove .htaccess files - we're use apache config instead
find %buildroot%installdir -name .htaccess -delete

# remove files
find %buildroot%installdir -name remove.txt -delete
find $RPM_BUILD_ROOT \( -name 'Thumbs.db' -o -name 'Thumbs.db.gz' \) -print -delete



%post apache
%_initdir/httpd condreload

%postun apache
%_initdir/httpd condreload


%post apache2
%_initdir/httpd2 condreload

%postun apache2
%_initdir/httpd2 condreload


%files
%dir %installdir
%dir %attr(2770,root,%webserver_group) %installdir/config
%config %attr(0664,root,%webserver_group) %installdir/config/based_config.php
%config %attr(0664,root,%webserver_group) %installdir/config/config.php
%config %attr(0664,root,%webserver_group) %installdir/config/define.php
%dir %attr(2770,root,%webserver_group) %installdir/files
%attr(2770,root,%webserver_group) %installdir/files/*
%installdir/ajax
%installdir/config
%installdir/css
%installdir/files
%installdir/front
%installdir/inc
%installdir/install
%installdir/lib
%installdir/locales
%installdir/pics
%installdir/plugins
%installdir/scripts
%installdir/*.php
%installdir/*.js
%installdir/COPYING.txt
%doc AUTHORS.txt
%doc CHANGELOG.txt
%doc README.txt
%doc README.ALT


%files apache
%config(noreplace) %attr(0644,root,root) %_sysconfdir/httpd/conf/addon-modules.d/%name.conf


%files apache2
%config(noreplace) %attr(0644,root,root) %_sysconfdir/httpd2/conf/addon.d/A.%name.conf


%files php5


%changelog
