# SPEC file for gltron game

%define version 0.70
%define release alt4.2

Name: gltron
Version: %version
Release: %release

Summary: a 3d lightcycle game using OpenGL
Summary(ru_RU.UTF-8): трехмерная игра с использованием OpenGL

License: GPL
Group: Games/Arcade
URL: http://www.gltron.org/

Packager: Nikolay A. Fetisov <naf@altlinux.ru>

Source:  %name-%version-source.tar.gz
Source1: %name.desktop
Source2: armagetronad-16.png
Source3: armagetronad-32.png
Source4: armagetronad-48.png
Patch0:  %name-0.70-alt-build_warnings_fix.patch
Patch1: %name-0.70-alt-no-Werror.patch
Patch2: %name-0.70-alt-no-conflict-decl.patch

BuildRequires: gcc-c++ libSDL-devel libSDL_sound-devel libsmpeg-devel libmikmod-devel libpng-devel libvorbis-devel

%description
A 3D lightcycle Tron game using OpenGL.

Player controls a  'Light Cycle' which leaves a wall behind
it wherever the  cycle it goes,  turning only at  90 degree 
angles. The player must then get the AI to crash into their 
wall while avoiding hitting the AI's own wall themselves.

%description -l ru_RU.UTF-8
Трехмерная игра Tron с использованием OpenGL.

Игрок управляет "световым мотоциклом", который при движении
оставляет  за собой стену  и может  только поворачивать под 
прямыми углами. Требуется заставить соперников (управляемых 
компьютером) врезаться в стены,  в то же время избегая стен 
самому.


%prep
%setup
%patch0
%patch1 -p2
%patch2 -p2

/bin/mv -f COPYING COPYING.GPL.orig
/bin/ln -s $(relative %_licensedir/GPL-2 %_docdir/%name/COPYING) COPYING

%build
%configure
%make_build  

%install
/bin/mkdir -p %buildroot
%make_install DESTDIR=%buildroot install

/bin/mkdir -p %buildroot%_desktopdir
/bin/install -m 0644 %SOURCE1 %buildroot%_desktopdir

/bin/mkdir -p -- %buildroot%_miconsdir %buildroot%_liconsdir %buildroot%_niconsdir
/bin/install -m0644 -- %SOURCE2 %buildroot%_miconsdir/%name.png
/bin/install -m0644 -- %SOURCE3 %buildroot%_niconsdir/%name.png
/bin/install -m0644 -- %SOURCE4 %buildroot%_liconsdir/%name.png

%files
%doc ChangeLog README
%doc --no-dereference COPYING

%_bindir/%name
%_datadir/%name
%_desktopdir/%name.desktop

%_miconsdir/%{name}*
%_niconsdir/%{name}*
%_liconsdir/%{name}*


%changelog
