# This spec is backported to ALTLinux p8 automatically by rpmbph script from etersoft-build-utils.
#
# For minor update, merge with new tag, update version in the spec and do gear-update-tag -a
# For major update, checkout new branch upstream-vX.Y, commit .gear dir to it, do git mergs -s ours from gear/sisyphus and build

%define oname glusterfs
%define major 3.12
%define _with_fusermount yes
%define _without_ocf yes
%def_without ganesha

# if you wish to compile an rpm without rdma support, compile like this...
# rpmbuild -ta @PACKAGE_NAME@-@PACKAGE_VERSION@.tar.gz --without rdma
%{?_without_rdma:%global _without_rdma --disable-ibverbs}

# if you wish to compile an rpm without epoll...
# rpmbuild -ta @PACKAGE_NAME@-@PACKAGE_VERSION@.tar.gz --without epoll
%{?_without_epoll:%global _without_epoll --disable-epoll}

# if you wish to compile an rpm with fusermount...
# rpmbuild -ta @PACKAGE_NAME@-@PACKAGE_VERSION@.tar.gz --with fusermount
%{?_with_fusermount:%global _with_fusermount --enable-fusermount}

# if you wish to compile an rpm without geo-replication support, compile like this...
# rpmbuild -ta @PACKAGE_NAME@-@PACKAGE_VERSION@.tar.gz --without georeplication
%{?_without_georeplication:%global _without_georeplication --disable-geo-replication}

# if you wish to compile an rpm without the OCF resource agents...
# rpmbuild -ta @PACKAGE_NAME@-@PACKAGE_VERSION@.tar.gz --without ocf
%{?_without_ocf:%global _without_ocf --without-ocf}

Name: glusterfs3
Version: %major.15
Release: alt0.M80P.1

Summary: Cluster File System

License: GPLv2/LGPLv3
Group: System/Base
Url: http://www.gluster.org/

Packager: Vitaly Lipatov <lav@altlinux.ru>

# Source0-git: https://github.com/gluster/glusterfs.git
Source0: %name-%version.tar
Source1: glusterd.sysconfig
Source2: %name.watch
Source3: umount.glusterfs

Source4: glusterfs.logrotate

Source7: glusterd.init
Source8: glustereventsd.init


Patch: %name-%version-%release.patch

%add_verify_elf_skiplist %_libdir/libgfdb.so.0.0.1
%add_verify_elf_skiplist %_libdir/libgfrpc.so.0.0.1
%add_verify_elf_skiplist %_libdir/glusterfs/xlator/mount/fuse.so

%define _init_install() install -D -p -m 0755 %1 %buildroot%_initdir/%2 ;

%define glusterlibdir %_libdir/glusterfs/%version

# manually removed: -static i586-glibc-devel i586-libssl-devel python-module-google python-module-mwlib python-module-oslo.config python-module-oslo.serialization python3 ruby ruby-stdlibs
# Automatically added by buildreq on Sat Jun 13 2015
# optimized out: gnu-config i586-glibc-core i586-glibc-pthread i586-libcrypto10 libcom_err-devel libdevmapper-devel libdevmapper-event libibverbs-devel libkrb5-devel libncurses-devel libssl-devel libtinfo-devel pkg-config python-base python-devel python-module-distribute python-module-oslo.i18n python-module-oslo.utils python-modules python-modules-ctypes python3-base userspace-rcu
BuildRequires: flex glib2-devel glibc-devel-static libacl-devel libaio-devel libattr-devel libdb4-devel liblvm2-devel libreadline-devel libsqlite3-devel libuuid-devel libxml2-devel python-module-cmd2 zlib-devel

BuildPreReq: libssl-devel

BuildPreReq: libuserspace-rcu-devel >= 0.9.1

Conflicts: %oname

Obsoletes: %oname-common < 3.1.0
Provides: %name-common = %version-%release
Provides: %name-core = %version-%release

BuildRequires: rpm-build-compat >= 1.7.24

%description
GlusterFS is a clustered file-system capable of scaling to several
petabytes. It aggregates various storage bricks over Infiniband RDMA
or TCP/IP interconnect into one large parallel network file
system. GlusterFS is one of the most sophisticated file systems in
terms of features and extensibility.  It borrows a powerful concept
called Translators from GNU Hurd kernel. Much of the code in GlusterFS
is in user space and easily manageable.

This package includes the glusterfs binary, the glusterfsd daemon and the
gluster command line, libglusterfs and glusterfs translator modules common to
both GlusterFS server and client framework.

%if 0%{!?_without_rdma:1}
%package rdma
Summary: GlusterFS rdma support for ib-verbs
Group: System/Base
BuildRequires: libibverbs-devel
BuildRequires: librdmacm-devel >= 1.0.19.1-alt1

Requires: %name = %version-%release

%description rdma
GlusterFS is a clustered file-system capable of scaling to several
petabytes. It aggregates various storage bricks over Infiniband RDMA
or TCP/IP interconnect into one large parallel network file
system. GlusterFS is one of the most sophisticated file systems in
terms of features and extensibility.  It borrows a powerful concept
called Translators from GNU Hurd kernel. Much of the code in GlusterFS
is in user space and easily manageable.

This package provides support to ib-verbs library.
%endif

%if_with ganesha
%package ganesha
Summary: NFS-Ganesha configuration
Group: System/Base
Requires: %name-server = %version-%release
Requires: nfs-ganesha
#Requires:         pcs
AutoReq: yes,noshell

%description ganesha
GlusterFS is a distributed file-system capable of scaling to several
petabytes. It aggregates various storage bricks over Infiniband RDMA
or TCP/IP interconnect into one large parallel network file
system. GlusterFS is one of the most sophisticated file systems in
terms of features and extensibility.  It borrows a powerful concept
called Translators from GNU Hurd kernel. Much of the code in GlusterFS
is in user space and easily manageable.

This package provides the configuration and related files for using
NFS-Ganesha as the NFS server using GlusterFS.
%endif

%if 0%{!?_without_georeplication:1}
%package geo-replication
Summary: GlusterFS Geo-replication
Group: System/Base
Requires: %name = %version-%release
Requires: python-modules-ctypes, rsync >= 3.0.0

%description geo-replication
GlusterFS is a clustered file-system capable of scaling to several
peta-bytes. It aggregates various storage bricks over Infiniband RDMA
or TCP/IP interconnect into one large parallel network file
system. GlusterFS is one of the most sophisticated file system in
terms of features and extensibility.  It borrows a powerful concept
called Translators from GNU Hurd kernel. Much of the code in GlusterFS
is in userspace and easily manageable.

This package provides support to geo-replication.
%endif

%package client
Summary: GlusterFS client
Group: System/Base
BuildRequires: libfuse-devel

Requires: %name = %version-%release

Obsoletes: %name-client < 3.1.0
Provides: %name-client = %version-%release

%description client
GlusterFS is a clustered file-system capable of scaling to several
petabytes. It aggregates various storage bricks over Infiniband RDMA
or TCP/IP interconnect into one large parallel network file
system. GlusterFS is one of the most sophisticated file systems in
terms of features and extensibility.  It borrows a powerful concept
called Translators from GNU Hurd kernel. Much of the code in GlusterFS
is in user space and easily manageable.

This package provides support to FUSE based clients.

%package -n lib%name-api
Summary: GlusterFS api library
Group: System/Libraries
#Requires: %name = %version-%release
#Requires:         %name-client-xlators = %version-%release

%description -n lib%name-api
GlusterFS is a distributed file-system capable of scaling to several
petabytes. It aggregates various storage bricks over Infiniband RDMA
or TCP/IP interconnect into one large parallel network file
system. GlusterFS is one of the most sophisticated file systems in
terms of features and extensibility.  It borrows a powerful concept
called Translators from GNU Hurd kernel. Much of the code in GlusterFS
is in user space and easily manageable.

This package provides the glusterfs libgfapi library.

%package -n lib%name-api-devel
Summary: Development libraries for GlusterFS api library
Group: Development/Other
Requires: lib%name-api = %version-%release
Requires: lib%name-devel = %version-%release

%description -n lib%name-api-devel
GlusterFS is a distributed file-system capable of scaling to several
petabytes. It aggregates various storage bricks over Infiniband RDMA
or TCP/IP interconnect into one large parallel network file
system. GlusterFS is one of the most sophisticated file systems in
terms of features and extensibility.  It borrows a powerful concept
called Translators from GNU Hurd kernel. Much of the code in GlusterFS
is in user space and easily manageable.

This package provides the api include files.

%package server
Summary: Clustered file-system server
Group: System/Servers
Requires: %name = %version-%release
Requires: %name-client = %version-%release

%description server
GlusterFS is a clustered file-system capable of scaling to several
petabytes. It aggregates various storage bricks over Infiniband RDMA
or TCP/IP interconnect into one large parallel network file
system. GlusterFS is one of the most sophisticated file systems in
terms of features and extensibility.  It borrows a powerful concept
called Translators from GNU Hurd kernel. Much of the code in GlusterFS
is in user space and easily manageable.

This package provides the glusterfs server daemon.

%package events
Summary: GlusterFS Events
Group: System/Servers
Requires: %name = %version-%release
Requires: python-module-%name = %version-%release

%description events
GlusterFS Events

%package vim
Summary: Vim syntax file
Group: Editors
Requires: vim-common
BuildArch: noarch

%description vim
GlusterFS is a clustered file-system capable of scaling to several
petabytes. It aggregates various storage bricks over Infiniband RDMA
or TCP/IP interconnect into one large parallel network file
system. GlusterFS is one of the most sophisticated file systems in
terms of features and extensibility.  It borrows a powerful concept
called Translators from GNU Hurd kernel. Much of the code in GlusterFS
is in user space and easily manageable.

Vim syntax file for GlusterFS.

%package -n lib%name-devel
Summary: Development Libraries
Group: Development/Other
Requires: lib%name = %version-%release
Requires: lib%name-api-devel = %version-%release
Conflicts: %oname-devel
Obsoletes: %name-devel < %version-%release
Provides: %name-devel = %version-%release

%description -n lib%name-devel
GlusterFS is a clustered file-system capable of scaling to several
petabytes. It aggregates various storage bricks over Infiniband RDMA
or TCP/IP interconnect into one large parallel network file
system. GlusterFS is one of the most sophisticated file systems in
terms of features and extensibility.  It borrows a powerful concept
called Translators from GNU Hurd kernel. Much of the code in GlusterFS
is in user space and easily manageable.

This package provides the development libraries.

%package -n python-module-%name
Summary: Python module for %name
Group: Development/Python
BuildArch: noarch
%setup_python_module %name

%description -n python-module-%name
This package provides Python API for %name

%package -n lib%name
Summary: GlusterFS common libraries
Group: System/Base
Obsoletes: %oname-libs <= 2.0.0
Obsoletes: %name-libs
Provides: %name-libs = %version-%release

%description -n lib%name
GlusterFS is a distributed file-system capable of scaling to several
petabytes. It aggregates various storage bricks over Infiniband RDMA
or TCP/IP interconnect into one large parallel network file
system. GlusterFS is one of the most sophisticated file systems in
terms of features and extensibility.  It borrows a powerful concept
called Translators from GNU Hurd kernel. Much of the code in GlusterFS
is in user space and easily manageable.

This package provides the base GlusterFS libraries.

%prep
%setup
%patch -p1
# due _libexecdir is /usr/lib
%__subst "s|/libexec/glusterfs|/lib/glusterfs|" ./configure.ac
# see build-aux/pkg-version
echo "v%version-%release" >VERSION

%build
# need from build from git repo (but incorporated in tarballs)
./autogen.sh
%configure  %{?_without_rdma} %{?_without_epoll} %{?_with_fusermount} %{?_without_georeplication} \
%{?_without_ocf} \
            --with-systemddir=%_unitdir \
            --localstatedir=/var/ \
            --libexecdir=%_libexecdir \
            --enable-qemu-block \
            --enable-bd-xlator

# Remove rpath
%__subst 's|^hardcode_libdir_flag_spec=.*|hardcode_libdir_flag_spec=""|g' libtool
%__subst 's|^runpath_var=LD_RUN_PATH|runpath_var=DIE_RPATH_DIE|g' libtool

%make_build

%install
%makeinstall_std
# Install include directory
mkdir -p %buildroot%_includedir/glusterfs
install -p -m 0644 libglusterfs/src/*.h \
%buildroot%_includedir/glusterfs/
install -p -m 0644 contrib/uuid/*.h \
%buildroot%_includedir/glusterfs/
# Following needed by hekafs multi-tenant translator
mkdir -p %buildroot%_includedir/glusterfs/rpc
install -p -m 0644 rpc/rpc-lib/src/*.h \
%buildroot%_includedir/glusterfs/rpc/
install -p -m 0644 rpc/xdr/src/*.h \
%buildroot%_includedir/glusterfs/rpc/
mkdir -p %buildroot%_includedir/glusterfs/server
install -p -m 0644 xlators/protocol/server/src/*.h \
%buildroot%_includedir/glusterfs/server/
# We'll use our init.d
rm -f %buildroot/etc/init.d/glusterd

# Create logging directory
mkdir -p %buildroot%_logdir/glusterfs/

# Remove unwanted files from all the shared libraries
find %buildroot%_libdir -name '*.a' -delete
find %buildroot%_libdir -name '*.la' -delete

# Remove installed docs, we include them ourselves as %%doc
rm -rf %buildroot%_docdir/glusterfs/
# move binary from datadir to bindir
mv %buildroot%_datadir/glusterfs/scripts/gsync-sync-gfid %buildroot%_bindir/

# Rename the samples, so we can include them as %%config
#for file in %buildroot%_sysconfdir/glusterfs/*.sample; do
#  mv ${file} `dirname ${file}`/`basename ${file} .sample`
#done

# Remove wrong placed confs
for file in glusterfs-georep-logrotate glusterfs-logrotate; do
  rm -v %buildroot%_sysconfdir/glusterfs/${file}
done

# Create working directory
mkdir -p %buildroot%_sharedstatedir/glusterd/

# Update configuration file to /var/lib working directory
%__subst 's|option working-directory %_sysconfdir/glusterd|option working-directory %_sharedstatedir/glusterd|g' \
    %buildroot%_sysconfdir/glusterfs/glusterd.vol

install -D -m644 extras/systemd/glusterd.service %buildroot/%_unitdir/glusterd.service
install -D -m644 extras/systemd/glustereventsd.service %buildroot/%_unitdir/glustereventsd.service

# Install init script and sysconfig file
%_init_install %SOURCE7 glusterd
%_init_install %SOURCE8 glustereventsd
install -D -p -m 0644 %SOURCE1 %buildroot%_sysconfdir/sysconfig/glusterd
# Install wrapper umount script
install -D -p -m 0755 %SOURCE3 %buildroot/sbin/umount.glusterfs

%if 0%{!?_without_georeplication:1}
install -D -p -m 0644 extras/glusterfs-georep-logrotate %buildroot%_sysconfdir/logrotate.d/glusterfs-georep
%endif
install -D -p -m 0644 %SOURCE4 %buildroot%_sysconfdir/logrotate.d/glusterfs

install -D -p -m 644 extras/glusterfs.vim \
%buildroot%_datadir/vim/vimfiles/syntax/glusterfs.vim

%if 0%{?_without_ocf:1}
rm -rf %buildroot%_libexecdir/ocf/
%endif

rm -rf %buildroot%_sbindir/conf.py

# TODO: selinux
# rm HACK due S10selinux-label-brick.sh: line 46: syntax error near unexpected token `('
rm -fv %buildroot%_sharedstatedir/glusterd/hooks/1/create/post/S10selinux-label-brick.sh
# drop req on policycoreutils (semanage)
rm -fv %buildroot%_sharedstatedir/glusterd/hooks/1/delete/pre/S10selinux-del-fcontext.sh

# TODO: move common part to -common?
%files
%doc ChangeLog INSTALL README.md THANKS COPYING-GPLV2 COPYING-LGPLV3
%_bindir/glusterfind

# cli
%_sbindir/gluster
%_sbindir/gluster-setgfid2path
%_man8dir/gluster.*
%_man8dir/gluster-setgfid2path.*

%glusterlibdir/rpc-transport/
%glusterlibdir/auth/
%glusterlibdir/xlator/
%exclude %glusterlibdir/xlator/mount/api.so
%_libexecdir/glusterfs/glusterfind/
%_sbindir/gfind_missing_files
%_libexecdir/glusterfs/gfind_missing_files/
%_sbindir/gcron.py
%_sbindir/snap_scheduler.py
%exclude %glusterlibdir/xlator/mount/fuse*
%_logdir/glusterfs/
%exclude %_man8dir/mount.glusterfs.8*
%if 0%{!?_without_rdma:1}
%exclude %glusterlibdir/rpc-transport/rdma*
%endif

%if 0%{!?_without_rdma:1}
%files rdma
%glusterlibdir/rpc-transport/rdma*
%endif

%if 0%{!?_without_georeplication:1}
%files geo-replication
%dir %_libexecdir/glusterfs/
%_libexecdir/glusterfs/gsyncd
%dir %_libexecdir/glusterfs/python/
%_libexecdir/glusterfs/gverify.sh
%_libexecdir/glusterfs/peer_add_secret_pub
%_libexecdir/glusterfs/peer_gsec_create
%_libexecdir/glusterfs/python/syncdaemon/
%_libexecdir/glusterfs/set_geo_rep_pem_keys.sh
%_datadir/glusterfs/scripts/get-gfid.sh
%_datadir/glusterfs/scripts/slave-upgrade.sh
%_datadir/glusterfs/scripts/gsync-upgrade.sh
%_datadir/glusterfs/scripts/generate-gfid-file.sh
%_datadir/glusterfs/scripts/schedule_georep.py
%_bindir/gsync-sync-gfid
%_libexecdir/glusterfs/peer_georep-sshkey.py
%_libexecdir/glusterfs/peer_mountbroker
%_libexecdir/glusterfs/peer_mountbroker.py
%_sbindir/gluster-georep-sshkey
%_sbindir/gluster-mountbroker
%config(noreplace) %_sysconfdir/logrotate.d/glusterfs-georep
%endif

%files -n lib%name-api
# libgfapi files
%_libdir/libgfapi.so.*
%glusterlibdir/xlator/mount/api.so

%files -n lib%name-api-devel
%_pkgconfigdir/glusterfs-api.pc
%_libdir/libgfapi.so
%_includedir/glusterfs/api/

%files client
# CHECKME: glusterfs is a symlink to glusterfsd, -server depends on -client.
%_sbindir/glusterfs
%_sbindir/glusterfsd
%_man8dir/glusterfs.8*
%_man8dir/glusterfsd.8*
%config(noreplace) %_sysconfdir/logrotate.d/glusterfs
%glusterlibdir/xlator/mount/fuse*
%_man8dir/mount.glusterfs.8*
/sbin/mount.glusterfs
/sbin/umount.glusterfs
%if 0%{?_with_fusermount:1}
%_bindir/fusermount-glusterfs
%endif

%files server
%_sbindir/glusterd
%_man8dir/glusterd.8*
%_initdir/glusterd
%_unitdir/glusterd.service
%config(noreplace) %_sysconfdir/sysconfig/glusterd
%dir %_sysconfdir/glusterfs/
%config(noreplace) %_sysconfdir/glusterfs/*
%exclude %_sysconfdir/glusterfs/eventsconfig.json

%_sharedstatedir/glusterd/
%exclude %_sharedstatedir/glusterd/events/

%_sbindir/glfsheal
%_sbindir/gf_attach
%_libdir/libgfdb.so.*

%dir %_datadir/glusterfs/scripts/

%_datadir/glusterfs/scripts/post-upgrade-script-for-quota.sh
%_datadir/glusterfs/scripts/pre-upgrade-script-for-quota.sh
%_datadir/glusterfs/scripts/stop-all-gluster-processes.sh

%if 0%{!?_without_ocf:1}
%dir %_libexecdir/ocf/resource.d/
%_libexecdir/ocf/resource.d/glusterfs/
%endif

%if_with ganesha
%files ganesha
%dir /etc/ganesha/
%config(noreplace) /etc/ganesha/ganesha-ha.conf.sample
%_libexecdir/ganesha/create-export-ganesha.sh
#%_libexecdir/ganesha/copy-export-ganesha.sh
%_libexecdir/ganesha/dbus-send.sh
%_libexecdir/ganesha/ganesha-ha.sh
%_libexecdir/ganesha/generate-epoch.py
%if 0%{!?_without_ocf:1}
%_libexecdir/ocf/resource.d/heartbeat/
%endif
%endif

# Events
%files events
%config(noreplace) %_sysconfdir/glusterfs/eventsconfig.json
%dir %attr(0755,-,-) %_sharedstatedir/glusterd/events/
%_libexecdir/glusterfs/events/
%_libexecdir/glusterfs/peer_eventsapi.py*
%_sbindir/glustereventsd
%_sbindir/gluster-eventsapi
%_datadir/glusterfs/scripts/eventsdash.py*
%_unitdir/glustereventsd.service
%_initdir/glustereventsd

%files vim
%doc COPYING-GPLV2 COPYING-LGPLV3
%_datadir/vim/vimfiles/syntax/glusterfs.vim

%files -n lib%name-devel
%_includedir/glusterfs/
%exclude %_includedir/glusterfs/api/
%exclude %_includedir/glusterfs/y.tab.h
%_libdir/libgfchangelog.so
%_libdir/libgfrpc.so
%_libdir/libgfxdr.so
%_libdir/libgfdb.so
%_libdir/libglusterfs.so
%_pkgconfigdir/libgfchangelog.pc
# pkgconfiglib.req: WARNING: /tmp/.private/lav/glusterfs3-buildroot/usr/lib64/pkgconfig/libgfdb.pc: cannot find -lgfchangedb library path (skip)
%_pkgconfigdir/libgfdb.pc

%files -n lib%name

# until we got -common subpackage
%dir %_libdir/glusterfs/
%dir %glusterlibdir/
%dir %_datadir/glusterfs/
%dir %_libexecdir/glusterfs/

%_libdir/libgfchangelog.so.*
%_libdir/libgfrpc.so.*
%_libdir/libgfxdr.so.*
%_libdir/libglusterfs.so.*

%files -n python-module-%name
%python_sitelibdir_noarch/*

%post server
%post_service glusterd

%preun server
%preun_service glusterd

%changelog
