%define gimpplugindir %(gimptool-2.0 --gimpplugindir)
%def_enable zart

Name: gmic
Version: 1.7.2
Release: alt1

Summary: GREYC's Magic Image Converter
License: CeCILL v.2.0
Group: Graphics
Url: http://gmic.sourceforge.net/

Source: http://gmic.eu/files/source/%{name}_%version.tar.gz

Requires: lib%name = %version-%release

BuildRequires: dos2unix
BuildRequires: gcc-c++ imake libGraphicsMagick-c++-devel libImageMagick-devel libXext-devel libXrandr-devel
BuildRequires: libavformat-devel libfftw3-devel libgimp-devel libjpeg-devel libopencv-devel libpng-devel
BuildRequires: libswscale-devel libtiff-devel openexr-devel xorg-cf-files zlib-devel libgomp-devel
BuildRequires: libcurl-devel
# for zart
BuildRequires: libqt4-devel

%description
G'MIC (GREYC's Magic Image Converter) is an interpreter of image processing
macros whose goal is to convert, manipulate and visualize generic 1D/2D/3D
multi-spectral image datasets.

%package -n lib%name
Summary: GREYC's Magic Image Converter Library
Group: System/Libraries

%description -n lib%name
G'MIC (GREYC's Magic Image Converter) is an interpreter of image processing
macros whose goal is to convert, manipulate and visualize generic 1D/2D/3D
multi-spectral image datasets.

This package provides shared G'MIC library.

%package -n lib%name-devel
Summary: GREYC's Magic Image Converter Library (development package)
Group: Development/C++
Requires: lib%name = %version-%release

%description -n lib%name-devel
G'MIC (GREYC's Magic Image Converter) is an interpreter of image processing
macros whose goal is to convert, manipulate and visualize generic 1D/2D/3D
multi-spectral image datasets.

This package provides development files for GREYC's Magic Image Converter Library.

%package zart
Summary: GREYC's image processing language demo
Group: Graphics
Requires: lib%name = %version-%release

%description zart
ZArt is a computer program whose purpose is to demonstrate the possibilities of
the G'MIC image processing language by offering the choice of several
manipulations on a video stream acquired from a webcam. In other words, ZArt is
a GUI for G'MIC real-time manipulations on the output of a webcam.

%package -n gimp-plugin-gmic
Summary: Image denoising and interpolation plugin for GIMP
Group: Graphics
Requires: gimp

%description -n gimp-plugin-gmic
G'MIC (GREYC's Magic Image Converter) is an interpreter of image processing
macros whose goal is to convert, manipulate and visualize generic 1D/2D/3D
multi-spectral image datasets.

%prep
%setup -n gmic-%version
dos2unix src/Makefile
subst 's|\$(USR)/\$(LIB)/|$(USR)/%_lib/|' src/Makefile
%ifnarch %ix86 x86_64
subst 's|-mtune=generic||' src/Makefile
%endif

%build
%if_enabled zart
export QTDIR=%_qt4dir
export PATH=%_qt4dir/bin:$PATH
%endif
pushd src
%make_build NOSTRIP=1
popd

%install
pushd src
%makeinstall_std
popd

%if_enabled zart
pushd zart
%makeinstall_std
popd
%endif

%find_lang --with-man %name

%files -f %name.lang
%_bindir/%name
%_man1dir/%name.1.*
%doc README COPYING

%files -n lib%name
%_libdir/lib%name.so.*
%_libdir/libc%name.so.*

%files -n lib%name-devel
%_includedir/gmic.h
%_includedir/gmic_libc.h
%_libdir/lib%name.so
%_libdir/libc%name.so

%if_enabled zart
%files zart
%_bindir/zart
%doc zart/README zart/Licence_CeCILL_V2*
%endif

%files -n gimp-plugin-gmic
%gimpplugindir/plug-ins/*

%changelog
