%def_disable snapshot

%define ver_major 3.20
%define api_ver 1.0
%define _libexecdir %_prefix/libexec

%def_enable introspection
%def_enable gtk_doc

Name: gnome-bluetooth
Version: %ver_major.1
Release: alt0.M80P.1

Summary: The GNOME Bluetooth Subsystem
License: GPLv2/LGPLv2
Group: System/Libraries
Url: https://wiki.gnome.org/Projects/GnomeBluetooth

Provides: bluez-gnome = %version
Obsoletes: bluez-gnome < %version
Requires:  bluez >= 5
Requires: lib%name = %version-%release rfkill

%if_disabled snapshot
Source: ftp://ftp.gnome.org/pub/gnome/sources/%name/%ver_major/%name-%version.tar.xz
%else
Source: %name-%version.tar
%endif

%define gtk_ver 3.12.0

BuildRequires: gnome-common gtk-doc intltool yelp-tools itstool
BuildRequires: libgio-devel libgtk+3-devel >= %gtk_ver libudev-devel libnotify-devel
BuildRequires: libcanberra-gtk3-devel
%{?_enable_introspection:BuildRequires: gobject-introspection-devel libgtk+3-gir-devel}

%description
The GNOME Bluetooth Subsystem

%package -n lib%name
Summary: The GNOME Bluetooth Subsystem library
Group: System/Libraries

%description -n lib%name
This package provides GNOME Bluetooth Subsystem library

%package -n lib%name-gir
Summary: GObject introspection data for the GNOME Bluetooth library
Group: System/Libraries
Requires: lib%name = %version-%release

%description -n lib%name-gir
GObject introspection data for the GNOME Bluetooth library

%package -n lib%name-devel
Summary: The GNOME Bluetooth Subsystem development package
Group: Development/C
Requires: lib%name = %version-%release

%description -n lib%name-devel
This package provides GNOME Bluetooth Subsystem development files

%package -n lib%name-devel-doc
Summary: The GNOME Bluetooth Subsystem development documentation
Group: Development/C
BuildArch: noarch
Conflicts: lib%name < %version

%description -n lib%name-devel-doc
This package provides GNOME Bluetooth Subsystem development documentation

%package -n lib%name-gir-devel
Summary: GObject introspection devel data for the GNOME Bluetooth library
Group: System/Libraries
BuildArch: noarch
Requires: lib%name = %version-%release
Requires: lib%name-gir = %version-%release

%description -n lib%name-gir-devel
GObject introspection devel data for the GNOME Bluetooth library

%prep
%setup -q
[ ! -d m4 ] && mkdir m4

%build
%autoreconf
%configure \
	--disable-schemas-compile \
	--disable-icon-update \
	--disable-desktop-update \
	%{?_enable_gtk_doc:--enable-gtk-doc} \
	%{subst_enable introspection}
%make_build

%install
%makeinstall_std

mv %buildroot%_bindir/bluetooth-sendto %buildroot%_bindir/%name-sendto
mkdir -p %buildroot%_altdir
cat > %buildroot%_altdir/%name <<EOF
%_bindir/bluetooth-sendto	%_bindir/%name-sendto	10
EOF

find %buildroot -name "*.la" -delete

%find_lang --with-gnome --output=global.lang %name gnome-bluetooth2


%files -f global.lang
%doc AUTHORS README NEWS
%_altdir/%name
%_bindir/*
%_desktopdir/*.desktop
%_datadir/%name
%_iconsdir/hicolor/*/*/*
%_man1dir/*.1*

%files -n lib%name
%_libdir/lib%name.so.*

%files -n lib%name-devel
%_includedir/%name/
%_libdir/lib%name.so
%_pkgconfigdir/%name-%api_ver.pc

%files -n lib%name-devel-doc
%_datadir/gtk-doc/html/*

%if_enabled introspection
%files -n lib%name-gir
%_typelibdir/GnomeBluetooth-%api_ver.typelib

%files -n lib%name-gir-devel
%_girdir/GnomeBluetooth-%api_ver.gir
%endif

%changelog
