%def_disable snapshot
%define ver_major 3.24
%define xdg_name org.gnome.Calculator
%define _libexecdir %_prefix/libexec

Name: gnome-calculator
Version: %ver_major.0
Release: alt0.M80P.1

Summary: GTK+3 based desktop calculator
License: %gpl2plus
Group: Sciences/Mathematics
Url: https://wiki.gnome.org/Apps/Calculator

%if_disabled snapshot
Source: %gnome_ftp/%name/%ver_major/%name-%version.tar.xz
%else
Source: %name-%version.tar
%endif

Obsoletes: gcalctool <= 6.6.2
Provides: gcalctool = 6.6.2

BuildPreReq: rpm-build-licenses rpm-build-gnome

BuildPreReq: intltool yelp-tools
BuildPreReq: libgtk+3-devel >= 3.20.0
BuildRequires: libgio-devel >= 2.48.0 libxml2-devel vala-tools >= 0.24
BuildRequires: libmpfr-devel libgtksourceview3-devel >= 3.16
BuildRequires: libsoup-devel >= 2.42 libmpc-devel

%description
This package provides gcalctool, the calculator application that was
previously in the OpenWindows Deskset of the Solaris 8 operating system.

It incorporates a multiple precision arithmetic packages based on the work
of Professor Richard Brent.

A single graphics driver for GTK included with this package.

%prep
%setup
#find ./ -name "*.stamp" -delete

%build
%autoreconf
%configure --disable-static \
    --disable-schemas-compile
%make_build

%install
%makeinstall_std

%find_lang --with-gnome %name

%files -f %name.lang
%_bindir/*
%_libexecdir/%name-search-provider
%_libdir/%name/libcalculator.so
%_datadir/dbus-1/services/org.gnome.Calculator.SearchProvider.service
%_datadir/gnome-shell/search-providers/%xdg_name-search-provider.ini
%_desktopdir/%xdg_name.desktop
%_man1dir/%name.1.*
%_man1dir/gcalccmd.1.*
%config %_datadir/glib-2.0/schemas/org.gnome.calculator.gschema.xml
%_datadir/appdata/%xdg_name.appdata.xml
%doc NEWS

%exclude %_libdir/%name/*.la

%changelog
