%define ver_major 0.14
%define api_ver 0.14
%define _libexecdir %_prefix/libexec
%def_disable mozilla
%def_enable gnumeric
%if_enabled gnumeric
%define goffice_api_ver 0.10
%define gnumeric_api_ver 1.12
%define gnumeric_plugindir %(pkg-config --variable PluginDir libspreadsheet-%gnumeric_api_ver)
%endif

Name: gnome-chemistry-utils
Version: %ver_major.17
Release: alt1.M80P.2

Summary: A set of chemical utilities
Group: Sciences/Chemistry
License: GPLv2+
Url: http://gchemutils.nongnu.org/

Source: http://download.savannah.gnu.org/releases/gchemutils/%ver_major/%name-%version.tar.xz
Patch1: %name-0.10.12-alt-mozplugindir.patch

Requires: %name-data = %version-%release bodr chemical-mime-data

BuildRequires: gcc-c++ doxygen docbook-dtds
BuildRequires: gnome-doc-utils gnome-common intltool scrollkeeper man
BuildRequires: libgio-devel libgnomeoffice%goffice_api_ver-devel
%{?_enable_gnumeric:BuildRequires: libspreadsheet-devel}
BuildRequires: libgsf-devel libopenbabel-devel libGLU-devel
BuildRequires: bodr chemical-mime-data
%{?_enable_mozilla:BuildRequires: xulrunner-devel browser-plugins-npapi-devel}

%description
The Gnome chemistry Utils are a collection of libraries and programs for
the GNOME desktop which migh be useful for chemists and science
students.

This package provides.
* A 3D molecular structure viewer (GChem3D).
* A Chemical calculator (GChemCalc).
* A 2D structure editor (GChemPaint).
* A periodic table of the elements application (GChemTable).
* A crystalline structure editor (GCrystal).
* A spectra viewer (GSpectrum).

%package data
Summary: Arch independent files for the Gnome chemistry Utils
Group: Sciences/Chemistry
BuildArch: noarch

%description data
This package provides noarch data needed for the Gnome chemistry Utils to work.

%package -n mozilla-plugin-%name
Summary: Gnome chemistry Utils browser plugin
Group: Sciences/Chemistry
Requires: %name = %version-%release

%description -n mozilla-plugin-%name
This package contains Gnome chemistry Utils plugin for xullrunner-based
browsers.

%package -n gnumeric-plugin-%name
Summary: Gnome chemistry Utils plugin for Gnumeric
Group: Sciences/Chemistry
Requires: %name = %version-%release

%description -n gnumeric-plugin-%name
This package contains Gnome chemistry Utils plugin for Gnumeric
spreadsheet program.

%prep
%setup
%patch1 -b .mozplugindir

[ ! -d m4 ] && mkdir m4

%build
%autoreconf
%configure --disable-update-databases \
           --disable-schemas-compile \
           --disable-scrollkeeper \
           %{?_disable_mozilla:--disable-mozilla-plugin} \
           %{?_enable_mozilla:--with-mozilla-libdir=%browser_plugins_path}
%make_build

%install
%makeinstall_std

%define apps gchem3d-%api_ver gchemcalc-%api_ver gchempaint-%api_ver gchemtable-%api_ver gcrystal-%api_ver gspectrum-%api_ver

%find_lang --with-gnome --output=%name.lang gchemutils-%api_ver %apps

%files
%_bindir/*
%_libexecdir/babelserver
%_libdir/gchemutils
%_libdir/goffice/*/plugins/gchemutils
%_libdir/libgccv-%api_ver.so.*
%_libdir/libgcp-%api_ver.so.*
%_libdir/libgcu-%api_ver.so.*
%_libdir/libgcrystal-%api_ver.so.*
%_libdir/libgcugtk-%api_ver.so.*
%doc AUTHORS NEWS README TODO

%exclude %_libdir/*.so
%exclude %_datadir/mimelnk/

%files data -f %name.lang
%_datadir/applications/*
%_datadir/gchemutils/
%_datadir/icons/hicolor/*/*/*
%_datadir/mime/packages/gchemutils.xml
%_man1dir/*
%_datadir/glib-2.0/schemas/org.gnome.gchemutils.crystal.gschema.xml
%_datadir/glib-2.0/schemas/org.gnome.gchemutils.gschema.xml
%_datadir/glib-2.0/schemas/org.gnome.gchemutils.paint.gschema.xml
%_datadir/glib-2.0/schemas/org.gnome.gchemutils.paint.plugins.arrows.gschema.xml
%_datadir/appdata/*

%if_enabled mozilla
%files -n mozilla-plugin-%name
%_libexecdir/chem-viewer
%browser_plugins_path/libmozgcu.so
%exclude %browser_plugins_path/libmozgcu.la
%endif

%if_enabled gnumeric
%files -n gnumeric-plugin-%name
%gnumeric_plugindir/gchemutils/
%exclude %gnumeric_plugindir/gchemutils/*.la
%endif

%changelog
