%define xdg_name org.gnome.clocks
%define ver_major 3.24

Name: gnome-clocks
Version: %ver_major.0
Release: alt0.M80P.1

Summary: Clock application designed for GNOME 3
Group: Graphical desktop/GNOME
License: GPLv2+
Url: https://wiki.gnome.org/Apps/Clocks

Source: http://download.gnome.org/sources/%name/%ver_major/%name-%version.tar.xz

%define gweather_ver 3.20.0
%define geocode_ver 3.18.0
%define geoclue_ver 2.3.1
%define gtk_ver 3.20.0

Requires: geoclue2

BuildRequires: yelp-tools
BuildRequires: libgio-devel libgtk+3-devel >= %gtk_ver libnotify-devel
BuildRequires: libgsound-devel libgnome-desktop3-devel
BuildRequires: vala-tools gobject-introspection-devel libgtk+3-gir-devel
BuildRequires: libgweather-devel >= %gweather_ver libgeocode-glib-devel >= %geocode_ver
BuildRequires: libgeoclue2-devel >= %geoclue_ver

%description
Clock application designed for GNOME 3

%prep
%setup

%build
%autoreconf
%configure \
	--disable-schemas-compile
%make_build

%install
%makeinstall_std
%find_lang --with-gnome %name

%files -f %name.lang
%_bindir/%name
%_datadir/%name/
%_datadir/applications/%xdg_name.desktop
%_datadir/glib-2.0/schemas/%xdg_name.gschema.xml
%_datadir/dbus-1/services/%xdg_name.service
%_datadir/gnome-shell/search-providers/%xdg_name.search-provider.ini
%_datadir/icons/*/*/apps/%xdg_name.png
%_iconsdir/hicolor/symbolic/apps/%xdg_name-symbolic.svg
%_datadir/appdata/%xdg_name.appdata.xml
%doc README NEWS

%changelog
