%define ver_major 3.22
%define _libexecdir %_prefix/libexec
%define gst_api_ver 1.0
%define _name org.gnome.Contacts
%def_with cheese

Name: gnome-contacts
Version: %ver_major.1
Release: alt0.M80P.1

Summary: Contacts manager for GNOME
License: GPLv2+
Group: Graphical desktop/GNOME
Url: https://wiki.gnome.org/Apps/Contacts

Source: ftp://ftp.gnome.org/pub/gnome/sources/%name/%ver_major/%name-%version.tar.xz
#Source: %name-%version.tar

%define glib_ver 2.37.6
%define gtk_ver 3.20.0
%define vala_ver 0.17.2
%define tp_glib_ver 0.17.5
%define folks_ver 0.9.5
%define eds_ver 3.13.90
%define cheese_ver 3.5.90
%define geocode_ver 3.15.3

BuildRequires: libgio-devel >= %glib_ver libgtk+3-devel >= %gtk_ver libtelepathy-glib-devel >= %tp_glib_ver
BuildRequires: libfolks-devel >= %folks_ver libvala-devel >= %vala_ver libgnome-desktop3-devel
BuildRequires: libgnome-online-accounts-devel libgee0.8-devel evolution-data-server-devel >= %eds_ver
BuildRequires: libgeocode-glib-devel >= %geocode_ver libchamplain-gtk3-devel libclutter-gtk3-devel
%{?_with_cheese:BuildRequires: gstreamer%gst_api_ver-devel libcheese-devel >= %cheese_ver}
BuildRequires: gobject-introspection-devel vala-tools libgtk+3-gir-devel intltool
# for build from git
BuildRequires: libfolks-vala

%description
%name is a standalone contacts manager for GNOME desktop.

%prep
%setup

%build
%autoreconf
%configure
%make_build

%install
%makeinstall_std

%find_lang %name

%files -f %name.lang
%_bindir/%name
%_libexecdir/gnome-contacts-search-provider
%_datadir/applications/%_name.desktop
%_datadir/glib-2.0/schemas/%_name.gschema.xml
%_datadir/glib-2.0/schemas/%_name.enums.xml
%_datadir/dbus-1/services/%_name.service
%_datadir/dbus-1/services/%_name.SearchProvider.service
%_datadir/gnome-shell/search-providers/%_name.search-provider.ini
%_datadir/appdata/%_name.appdata.xml
%doc AUTHORS README NEWS

%changelog
