%def_disable snapshot

%define _libexecdir %_prefix/libexec
%define _name gnome-desktop
%define ver_major 3.24
%define api_ver 3.0
%define gnome_distributor "%vendor"
%define gnome_date "%(date "+%%B %%e %%Y"), Moscow"
%def_disable static
%def_enable gtk_doc
%def_enable introspection
%def_enable installed_tests
%def_enable udev

Name: %{_name}3
Version: %ver_major.2
Release: alt0.M80P.1

Summary: Library with common API for various GNOME 3 modules
License: %gpl2plus, %fdl
Group: Graphical desktop/GNOME
Url: http://www.gnome.org

%if_disabled snapshot
Source: %gnome_ftp/%_name/%ver_major/%_name-%version.tar.xz
%else
Source: %_name-%version.tar
%endif

Obsoletes: %_name
Provides: %_name = %version-%release

BuildPreReq: rpm-build-licenses rpm-build-gnome

# From configure.ac
BuildPreReq: gnome-common >= 2.8.0
BuildPreReq: intltool >= 0.40.6 yelp-tools gtk-doc
BuildPreReq: libgdk-pixbuf-devel >= 2.36.5
BuildPreReq: libgtk+3-devel >= 3.3.6
BuildPreReq: libgio-devel >= 2.44.0
BuildPreReq: gsettings-desktop-schemas-devel >= 3.5.91
BuildRequires: iso-codes-devel
BuildRequires: xkeyboard-config-devel
BuildRequires: libudev-devel
%{?_enable_introspection:BuildRequires: gobject-introspection-devel libgtk+3-gir-devel gsettings-desktop-schemas-gir-devel}

%description
GNOME (GNU Network Object Model Environment) is a user-friendly set of
applications and desktop tools to be used in conjunction with a window
manager for the X Window System.  GNOME is similar in purpose and scope
to CDE and KDE, but GNOME is based completely on free software. The

GNOME Desktop provides the core libraries for the gnome desktop.

%package -n lib%name
Summary: GNOME desktop core libraries
Group: Graphical desktop/GNOME
License: %lgpl2plus
Requires: icon-theme-hicolor
Requires: udev-hwdb

%description -n lib%name
Gnome 3 desktop libraries.

%package -n lib%name-devel
Summary: GNOME 3 desktop development libraries and includes
Group: Development/GNOME and GTK+
Requires: lib%name = %version-%release
License: %lgpl2plus, %fdl

%description -n lib%name-devel
Gnome 3 desktop libraries and header files for creating GNOME applications.

%package -n lib%name-devel-doc
Summary: GNOME 3 desktop development documentation
Group: Development/Documentation
Conflicts: lib%name-devel < %version
License: %lgpl2plus, %fdl
BuildArch: noarch

%description -n lib%name-devel-doc
Development documentation for Gnome 3 desktop library.

%if_enabled static
%package -n lib%name-devel-static
Summary: GNOME 3 desktop develop libraries and includes
Group: Development/GNOME and GTK+
Requires: lib%name-devel = %version-%release
License: %lgpl2plus

%description -n lib%name-devel-static
Gnome 3 desktop static libraries for creating GNOME applications.
%endif

%package -n lib%name-gir
Summary: GObject introspection data for the %_name library
Group: System/Libraries
Requires: lib%name = %version-%release

%description -n lib%name-gir
GObject introspection data for the %_name library

%package -n lib%name-gir-devel
Summary: GObject introspection devel data for the %_name
Group: System/Libraries
BuildArch: noarch
Requires: lib%name-gir = %version-%release

%description -n lib%name-gir-devel
GObject introspection devel data for the %_name library

%package tests
Summary: Tests for the Gnome 3 desktop library
Group: Development/Other
Requires: lib%name = %version-%release

%description tests
This package provides tests programs that can be used to verify
the functionality of the Gnome 3 desktop library.


%prep
%setup -n %_name-%version
[ ! -d m4 ] && mkdir m4

%build
%autoreconf
%configure \
    %{subst_enable static} \
    %{?_enable_gtk_doc:--enable-gtk-doc} \
    --with-gnome-distributor=%gnome_distributor \
    %{?_enable_installed_tests:--enable-installed-tests} \
    %{subst_enable udev}
%make_build

%install
%makeinstall_std

%find_lang --with-gnome --output=%_name.lang %_name-%api_ver fdl gpl lgpl

%files

%files -n lib%name -f %_name.lang
%_libdir/*.so.*
%doc AUTHORS NEWS README

%files -n lib%name-devel
%_libexecdir/gnome-rr-debug
%_includedir/*
%_libdir/*.so
%_datadir/gnome/gnome-version.xml
%_pkgconfigdir/*

%files -n lib%name-devel-doc
%_datadir/gtk-doc/html/*

%if_enabled static
%files -n lib%name-devel-static
%_libdir/*.a
%endif

%if_enabled introspection
%files -n lib%name-gir
%_typelibdir/*

%files -n lib%name-gir-devel
%_girdir/*
%endif

%if_enabled installed_tests
%files tests
%_libexecdir/installed-tests/%_name/
%_datadir/installed-tests/%_name/
%endif


%changelog
