%define _unpackaged_files_terminate_build 1

%define _name baobab
%define __name org.gnome.baobab
%define ver_major 3.24
%set_typelibdir %_libdir/%_name/girepository-1.0

Name: gnome-disk-usage
Version: %ver_major.0
Release: alt0.M80P.1

Summary: The GNOME disk usage analyser.
License: GPLv2+
Group: Graphical desktop/GNOME
Url: https://wiki.gnome.org/Apps/Baobab

Source: %gnome_ftp/%_name/%ver_major/%_name-%version.tar.xz

Provides: baobab = %version-%release

%define gtk_ver 3.20.0
%define vala_ver 0.23.3
BuildPreReq: libgtk+3-devel >= %gtk_ver
BuildRequires: rpm-build-gnome yelp-tools itstool xmllint libappstream-glib-devel
BuildRequires: vala-tools >= %vala_ver gobject-introspection-devel libgtk+3-gir-devel

%description
Baobab is a graphical tool to analyse disk usage in local and remote
filesystems.

%prep
%setup -n %_name-%version

%build
%autoreconf
%configure
%make_build

%install
%makeinstall_std

pushd %buildroot%_bindir
ln -s baobab gnome-disk-usage
popd

%find_lang --with-gnome %_name

%files -f %_name.lang
%_bindir/%_name
%_bindir/gnome-disk-usage
%_desktopdir/%__name.desktop
%_iconsdir/hicolor/*/apps/%_name.*
%_iconsdir/hicolor/scalable/apps/%_name-symbolic.svg
%_man1dir/%_name.1.*
%_datadir/dbus-1/services/%__name.service
%config %_datadir/glib-2.0/schemas/org.gnome.%_name.gschema.xml
%_datadir/appdata/%__name.appdata.xml

%changelog
