%define ver_major 3.24
%define xdg_name org.gnome.DiskUtility
%define _libexecdir %_prefix/libexec
%def_enable gsd_plugin

Name: gnome-disk-utility
Version: %ver_major.1
Release: alt0.M80P.1

Summary: Disk management application
License: LGPLv2+
Group: System/Libraries
Url: https://wiki.gnome.org/Apps/Disks

Requires: udisks2 cryptsetup
Requires: gnome-icon-theme-symbolic

Source: ftp://ftp.gnome.org/pub/gnome/sources/%name/%ver_major/%name-%version.tar.xz
Patch: %name-3.16.0-alt-lfs.patch

%define udisks_ver 2.1.1
%define glib_ver 2.31.0
%define gtk_ver 3.12.0
%define secret_ver 0.7
%define pwquality_ver 1.0.0
%define dvdread_ver 4.2.0
%define lzma_ver 5.0.5

BuildRequires: autoconf-archive xsltproc libappstream-glib-devel
BuildPreReq: libudisks2-devel >= %udisks_ver
BuildPreReq: libgio-devel  >= %glib_ver
BuildPreReq: libgtk+3-devel >= %gtk_ver
BuildPreReq: libsecret-devel >= %secret_ver
BuildPreReq: libpwquality-devel >= %pwquality_ver
BuildPreReq: libdvdread-devel >= %dvdread_ver
BuildPreReq: liblzma-devel >= %lzma_ver
BuildRequires: libnotify-devel libcanberra-gtk3-devel
BuildRequires: systemd-devel libsystemd-devel
BuildRequires: xsltproc docbook-style-xsl

%description
This package contains the Palimpsest disk management application.
Palimpsest supports partitioning, file system creation, encryption,
RAID, SMART monitoring, etc

%prep
%setup
%patch -p1

%build
%autoreconf
%configure \
	--disable-static \
	%{?_disable_gsd_plugin:--disable-gsd-plugin}
%make_build

%install
%makeinstall_std

%find_lang --with-gnome --output=global.lang %name palimpsest

%files -f global.lang
%_bindir/gnome-disk-image-mounter
%_bindir/gnome-disks

%if_enabled gsd_plugin
%_libexecdir/gsd-disk-utility-notify
%_sysconfdir/xdg/autostart/org.gnome.SettingsDaemon.DiskUtilityNotify.desktop
%endif

%_desktopdir/gnome-disk-image-mounter.desktop
%_desktopdir/gnome-disk-image-writer.desktop
%_desktopdir/%xdg_name.desktop
%_datadir/dbus-1/services/%xdg_name.service
%_datadir/glib-2.0/schemas/org.gnome.Disks.gschema.xml
%_iconsdir/hicolor/*/apps/*
%_datadir/appdata/%xdg_name.appdata.xml
%_man1dir/*.1.*


%changelog
