%def_disable snapshot

%define ver_major 3.24
%define _libexecdir %_prefix/libexec
%def_with compiz

Name: gnome-flashback
Version: %ver_major.0
Release: alt0.M80P.1

Summary: GNOME Flashback session
License: GPLv3
Group: Graphical desktop/GNOME
Url: https://wiki.gnome.org/Projects/GnomeFlashback

%if_disabled snapshot
Source: %gnome_ftp/%name/%ver_major/%name-%version.tar.xz
%else
Source: %name-%version.tar
%endif

%define glib_ver 2.44.0
%define gtk_ver 3.22.0
%define desktop_ver 3.12.0
%define dbus_glib_ver 0.76
%define gsds_ver 3.12.0

PreReq: xinitrc
Requires: gnome-session gnome-settings-daemon gnome-panel gnome-applets metacity3.0
Requires: libcanberra-gnome libcanberra-gtk3
Requires: altlinux-freedesktop-menu-gnome3
Requires: dbus-tools-gui
Requires: gnome-filesystem
Requires: xdg-user-dirs
Requires: gnome-icon-theme gnome-icon-theme-symbolic
Requires: fonts-otf-abattis-cantarell gnome-backgrounds
Requires: gnome-screensaver
Requires: gnome-keyring
Requires: gnome-control-center
Requires: nautilus
# since 3.18
Requires: polkit accountsservice
Requires: pinentry-gnome3
Requires: upower
Requires: bluez
Requires: NetworkManager-applet-gtk
Requires: ibus xkeyboard-config
# since 3.20
Conflicts: notification-daemon < 3.20

BuildRequires: rpm-build-gnome gnome-common
BuildRequires: libgio-devel >= %glib_ver
BuildRequires: libgtk+3-devel >= %gtk_ver
BuildRequires: libdbus-glib-devel >= %dbus_glib_ver
BuildRequires: libgnome-desktop3-devel >= %desktop_ver
BuildRequires: gsettings-desktop-schemas-devel >= %gsds_ver
BuildRequires: libcanberra-gtk3-devel libpulseaudio-devel
BuildRequires: libXext-devel libXrandr-devel
BuildRequires: libupower-devel
# since 3.18
BuildRequires: libpolkit-devel libgnome-bluetooth-devel libxcb-devel
BuildRequires: libibus-devel libxkbcommon-x11-devel libXi-devel
BuildRequires: libxkbfile-devel xkeyboard-config-devel

%description
GNOME Flashback provides unofficial session and helper application.

This session consists of gnome-applets, gnome-flashback, gnome-panel and
metacity. And all other modules that are used in official GNOME session.

Helper application main job is to provide all features that is need for
our session, but has been removed from GNOME and/or moved to mutter or
gnome-shell.

NOTE: This session is not supported by GNOME in any way!

%package session-compiz
Summary: A Compiz session for the GNOME Flashback
Group: Graphical desktop/GNOME
BuildArch: noarch
Requires: %name = %version-%release
Requires: compiz

%description session-compiz
This package permits to log into GNOME Flashback with Compiz.


%prep
%setup

%build
%autoreconf
%configure \
    --disable-schemas-compile
%make_build

%install
%makeinstall_std

# link to our gnome3 menus
ln -sf gnome-applications.menu %buildroot/%_xdgmenusdir/%name-applications.menu

%find_lang --with-gnome --output=%name.lang %name

%check
%make check

%files -f %name.lang
%_bindir/%name
%_libexecdir/%name-compiz
%_libexecdir/%name-metacity
%_desktopdir/%name.desktop
%_desktopdir/%name-init.desktop
%_datadir/desktop-directories/X-GNOME-Flashback-Settings-System.directory
%_datadir/desktop-directories/X-GNOME-Flashback-Settings.directory
%_datadir/gnome-session/sessions/%name-compiz.session
%_datadir/gnome-session/sessions/%name-metacity.session
%config %_datadir/glib-2.0/schemas/org.gnome.%name.gschema.xml
%_datadir/glib-2.0/schemas/org.gnome.%name.desktop-background.gschema.xml
%_datadir/glib-2.0/schemas/org.gnome.%name.input-sources.gschema.xml
%_datadir/glib-2.0/schemas/org.gnome.%name.workarounds.gschema.xml
%_xdgmenusdir/%name-applications.menu
%_datadir/xsessions/%name-metacity.desktop
%_xdgconfigdir/autostart/%name-nm-applet.desktop
%_xdgconfigdir/autostart/%name-screensaver.desktop
%doc AUTHORS NEWS README

%if_with compiz
%files session-compiz
%_datadir/xsessions/%name-compiz.desktop
%endif


%changelog
