%define _unpackaged_files_terminate_build 1

%define _name chess
%define __name gnome-%_name
%define ver_major 3.24
%define _libexecdir %_prefix/libexec

Name: gnome-games-%_name
Version: %ver_major.1
Release: alt0.M80P.1

Summary: A chess game for GNOME
Group: Games/Boards
License: GPLv3+
Url: https://wiki.gnome.org/Apps/Chess

Source: ftp://ftp.gnome.org/pub/gnome/sources/%__name/%ver_major/%__name-%version.tar.xz

Provides:  %__name = %version-%release
Obsoletes: gnome-games-glchess
Provides:  gnome-games-glchess = %version-%release
Requires: gnuchess >= 6.2.3

%define glib_ver 2.40
%define gtk_ver 3.19.0
%define vala_ver 0.22.0

BuildRequires: gnome-common
BuildRequires: intltool yelp-tools libgio-devel >= %glib_ver libgtk+3-devel >= %gtk_ver
BuildRequires: librsvg-devel gsettings-desktop-schemas-devel libappstream-glib-devel
BuildRequires: libGL-devel libGLU-devel vala-tools >= %vala_ver

%description
A chess game which supports several chess engines, with 2D and optionally
3D support if OpenGL is present.

%prep
%setup -n %__name-%version
[ ! -d m4 ] && mkdir m4

%build
%autoreconf
%configure \
    --disable-schemas-compile

%make_build

%install
%makeinstall_std

%find_lang --with-gnome %__name

%files -f gnome-%_name.lang
%_bindir/%__name
%_desktopdir/%__name.desktop
%_datadir/%__name
%_iconsdir/hicolor/*x*/apps/%__name.png
%_iconsdir/hicolor/scalable/apps/%{__name}*.svg
%_man6dir/%__name.*
%config %_datadir/glib-2.0/schemas/org.gnome.%_name.gschema.xml
%config(noreplace) %_sysconfdir/%__name/engines.conf
%_datadir/appdata/%__name.appdata.xml

%changelog
