%define _unpackaged_files_terminate_build 1

%define _name tetravex
%define __name gnome-%_name
%define ver_major 3.22
%define _libexecdir %_prefix/libexec

Name: gnome-games-%_name
Version: %ver_major.0
Release: alt0.M80P.1

Summary: A game based on Tetravex
Group: Games/Boards
License: GPLv3+
Url: https://wiki.gnome.org/Apps/Tetravex

Source: ftp://ftp.gnome.org/pub/gnome/sources/%__name/%ver_major/%__name-%version.tar.xz

Provides:  %_name = %version-%release
Obsoletes: gnome-games-gnotravex
Provides:  gnome-games-gnotravex = %version-%release

%define glib_ver 2.40.0
%define gtk_ver 3.14.0

BuildRequires: gnome-common intltool yelp-tools
BuildRequires: gsettings-desktop-schemas-devel libappstream-glib-devel
BuildRequires: libgio-devel >= %glib_ver libgtk+3-devel >= %gtk_ver librsvg-devel

%description
GNOME Tetravex is a simple puzzle where pieces must be positioned so
that the same numbers are touching each other. Your game is timed, these
times are stored in a system-wide scoreboard.

%prep
%setup -n %__name-%version

%build
%autoreconf
%configure  --disable-schemas-compile
%make_build

%install
%makeinstall_std

%find_lang --with-gnome %__name

%files -f %__name.lang
%_bindir/%__name
%_desktopdir/%__name.desktop
%_iconsdir/hicolor/*x*/apps/*.png
%_iconsdir/hicolor/scalable/apps/*.svg
%_man6dir/%__name.*
%config %_datadir/glib-2.0/schemas/org.gnome.%_name.gschema.xml
%_datadir/appdata/%__name.appdata.xml


%changelog
