%def_disable snapshot

%define ver_major 3.20
%def_disable static
%def_disable gtk_doc
%def_disable debug
%def_disable valgrind
%def_enable pam
%def_enable selinux
%def_disable ssh

Name: gnome-keyring
Version: %ver_major.1
Release: alt0.M80P.1

Summary: %name is a password keeper for GNOME
License: LGPL
Group: Graphical desktop/GNOME
Url: http://www.gnome.org

%if_disabled snapshot
Source: ftp://ftp.gnome.org/pub/gnome/sources/%name/%ver_major/%name-%version.tar.xz
%else
Source: %name-%version.tar
%endif
Patch: gnome-keyring-3.14.0-alt-lfs.patch

%define glib_ver 2.38.0
%define dbus_ver 1.0
%define gcrypt_ver 1.2.2
%define tasn1_ver 0.3.4
%define p11kit_ver 0.18.1
%define gcr_ver 3.5.3

Requires(post): libcap-utils
Requires: libp11-kit >= %p11kit_ver
%{?_disable_ssh:Requires: openssh-clients}

# From configure.ac
BuildPreReq: gnome-common libgio-devel >= %glib_ver
BuildPreReq: intltool >= 0.35.0 gtk-doc xsltproc
BuildPreReq: libdbus-devel >= %dbus_ver
BuildPreReq: libgcrypt-devel >= %gcrypt_ver
BuildPreReq: libtasn1-devel >= %tasn1_ver  libp11-kit-devel >= %p11kit_ver
BuildPreReq: gcr-libs-devel >= %gcr_ver
BuildRequires: libtasn1-utils
BuildRequires: libcap-ng-devel
%{?_enable_pam:BuildPreReq: libpam-devel}
%{?_enable_valgrind:BuildPreReq: valgrind}
%{?_enable_selinux:BuildRequires: libselinux-devel}
# for check
BuildRequires: /proc xvfb-run dbus-tools-gui

%description
%name is a program that keep password and other secrets for
users. It is run as a damon in the session, similar to ssh-agent, and
other applications can locate it by an environment variable.

%package -n pam_%name
Summary: A pam module for unlocking keyrings at login time
Group: System/Base
Requires: %name = %version-%release

%description -n pam_%name
The pam_gnome-keyring package contains a pam module that can
automatically unlock the "login" keyring when the user logs in
and start the keyring daemon.

%define _gtk_docdir %_datadir/gtk-doc/html
%define _libexecdir %_prefix/libexec/%name

%prep
%setup
%patch -p1 -b .lfs

%build
%autoreconf
%configure \
	%{?_enable_gtk_doc:--enable-gtk-doc} \
	%{subst_enable static} \
	%{subst_enable debug} \
	%{subst_enable valgrind} \
	%{subst_enable selinux} \
	%{?_disable_ssh:--disable-ssh-agent} \
	--enable-doc \
	--with-pam-dir=/%_lib/security

%make_build

%install
%makeinstall_std

%find_lang --with-gnome %name

%check
#%make check

%post
setcap cap_ipc_lock=ep %_bindir/gnome-keyring-daemon 2>/dev/null ||:

%files -f %name.lang
%_bindir/gnome-keyring
%_bindir/gnome-keyring-3
%_bindir/gnome-keyring-daemon
%_datadir/dbus-1/services/org.gnome.keyring.service
%_datadir/dbus-1/services/org.freedesktop.secrets.service
%_sysconfdir/xdg/autostart/*.desktop
%_datadir/glib-2.0/schemas/org.gnome.crypto.cache.gschema.xml
%_datadir/GConf/gsettings/org.gnome.crypto.cache.convert
%_datadir/p11-kit/modules/gnome-keyring.module
%_libdir/gnome-keyring/
%_libdir/pkcs11
%_man1dir/*
%doc README AUTHORS NEWS

%exclude %_libdir/pkcs11/*.la
%exclude %_libdir/gnome-keyring/*/*.la
%exclude /%_lib/security/*.la

%if_enabled pam
%files -n pam_%name
/%_lib/security/pam_gnome_keyring.so
%exclude /%_lib/security/pam_gnome_keyring.la
%endif


%changelog
