%define ver_major 3.24
%define xdg_name org.gnome.Music

Name: gnome-music
Version: %ver_major.2
Release: alt1.M80P.1

Summary: Music playing application for GNOME3
Group: Sound
License: GPLv2+
Url: http://wiki.gnome.org/Apps/Music

Source: ftp://ftp.gnome.org/pub/gnome/sources/%name/%ver_major/%name-%version.tar.xz

# use python3
AutoReqProv: nopython
%define __python %nil

%add_typelib_req_skiplist typelib(Gd)

Requires: tracker

%define gtk_ver 3.20.0
%define grilo_ver 0.3.1
%define python_ver 3.3
%define mediaart_ver 1.9
%define tracker_ver 1.11.1
%define pygobject_ver 3.21.1

# gir-python.req doesn't recognize multiline expressions (see gnomemusic/albumartcache.py)
Requires: typelib(MediaArt) = 2.0 typelib(GstTag)

Requires: gst-plugins-base1.0 grilo-tools >= %grilo_ver tracker >= %tracker_ver

BuildRequires: autoconf-archive intltool yelp-tools libgtk+3-devel >= %gtk_ver
BuildRequires: libgrilo-devel >= %grilo_ver libmediaart2.0-devel >= %mediaart_ver
BuildRequires: gobject-introspection-devel libgtk+3-gir-devel
BuildRequires: rpm-build-python3 python3-devel >= %python_ver
BuildRequires: tracker-devel >= %tracker_ver
BuildRequires: python3-module-pygobject3-devel >= %pygobject_ver

%description
Music playing application for GNOME3.

%prep
%setup

%build
%autoreconf
%configure
%make_build

%install
%makeinstall_std

%find_lang --with-gnome %name

%files -f %name.lang
%_bindir/%name
%_datadir/%name/
%_desktopdir/%name.desktop
%_datadir/glib-2.0/schemas/org.gnome.Music.gschema.xml
%_iconsdir/hicolor/*/apps/%name.png
%_iconsdir/hicolor/symbolic/apps/%{name}*.svg
%_libdir/%name/
%python3_sitelibdir_noarch/gnomemusic/
%_datadir/appdata/%name.appdata.xml
#%_man1dir/%name.1.*
%doc AUTHORS README

%exclude %_libdir/%name/libgd.la

%changelog
