%define ver_major 3.8

Name: gnome-nettool
Version: %ver_major.1
Release: alt2

Summary: GNOME interface for various networking tools
License: %gpl2only
Group: Graphical desktop/GNOME
Url: http://www.gnome.org
Packager: GNOME Maintainers Team <gnome@packages.altlinux.org>

Source: ftp://ftp.gnome.org/pub/gnome/sources/%name/%ver_major/%name-%version.tar.xz

Obsoletes: gnome-netinfo
Provides: gnome-netinfo = %version-%release

Requires: net-tools
Requires: iputils
Requires: traceroute
Requires: bind-utils
Requires: nmap
Requires: whois

BuildPreReq: rpm-build-gnome >= 0.6 gnome-common
BuildPreReq: rpm-build-licenses
BuildPreReq: desktop-file-utils >= 0.8

# From configure.in
BuildPreReq: intltool >= 0.40.1
BuildPreReq: libgtk+3-devel >= 2.99.2
BuildPreReq: libgio-devel libgtop-devel
BuildRequires: yelp-tools

%description
GNOME Nettool is a set of front-ends to various networking command-line
tools, like ping, netstat, ifconfig, whois, traceroute, finger.

%prep
%setup -q

# don't run gtk_update_icon_cache
subst '/install-data-hook: update-icon-cache/d' pixmaps/icons/Makefile.in

%build
%configure \
	--disable-scrollkeeper

#	--disable-schemas-compile

%make_build

%install
%make DESTDIR=%buildroot install

%find_lang --with-gnome %name

%files -f %name.lang
%_bindir/*
%_desktopdir/*
%_datadir/%name
%config %_datadir/glib-2.0/schemas/*.xml

#icons
%_iconsdir/hicolor/16x16/apps/%name.png
%_iconsdir/hicolor/22x22/apps/%name.png
%_iconsdir/hicolor/24x24/apps/%name.png
%_iconsdir/hicolor/32x32/apps/%name.png
%_iconsdir/hicolor/scalable/apps/%name.svg

%doc README NEWS TODO ChangeLog

%changelog
