%def_disable snapshot

%define ver_major 3.24
%define api_ver 3.0
%define applet_api_ver 5.0
%def_disable static
%def_disable gtk_doc
%def_disable introspection
%def_enable eds

Name: gnome-panel
Version: %ver_major.1
Release: alt0.M80P.1

Summary: The core programs for the GNOME GUI desktop environment
License: GPLv2+ and LGPLv2+ and GFDL+
Group: Graphical desktop/GNOME
Url: https://wiki.gnome.org/Projects/GnomePanel

%if_disabled snapshot
Source: %gnome_ftp/%name/%ver_major/%name-%version.tar.xz
%else
Source: %name-%version.tar
%endif

# From configure.ac
%define gtk_ver 3.20.0
%define desktop_ver 3.3.92
%define libpango_ver 1.15.4
%define glib_ver 2.36.0
%define libwnck_ver 3.4.6
%define dconf_ver 0.13.4
%define gnome_menus_ver 3.5.5
%define eds_ver 3.5.91
%define cairo_ver 1.0
%define tp_glib_ver 0.14
%define gweather_ver 3.17.1
%define rsvg_ver 2.36.2
%define gtk_doc_ver 1.24.1

Conflicts: gnome-power-manager < 2.15.3
Requires: lib%name = %version-%release
Requires: dconf gnome-icon-theme

# for Wanda
Requires: fortune-mod
# for clock
Requires: tzdata

BuildPreReq: rpm-build-gnome >= 0.4

# From configure.ac
BuildRequires: yelp-tools gtk-doc
%{?_enable_gtk_doc:BuildPreReq: gtk-doc >= %gtk_doc_ver}
BuildPreReq: libgnome-desktop3-devel >= %desktop_ver
BuildPreReq: libgtk+3-devel >= %gtk_ver
BuildPreReq: glib2-devel >= %glib_ver
BuildPreReq: libgio-devel >= %glib_ver
BuildPreReq: libpango-devel >= %libpango_ver
BuildPreReq: libwnck3-devel >= %libwnck_ver
BuildPreReq: libgnome-menus-devel >= %gnome_menus_ver
BuildPreReq: libcairo-devel >= %cairo_ver
BuildPreReq: libtelepathy-glib-devel >= %tp_glib_ver
BuildPreReq: libgweather-devel >= %gweather_ver
BuildPreReq: librsvg-devel >= %rsvg_ver
BuildRequires: libX11-devel libXt-devel libXau-devel libXrandr-devel libXi-devel libxml2-devel
BuildRequires: libdconf-devel >= %dconf_ver libpolkit-devel libSM-devel
BuildRequires: gdm-libs-devel
%{?_enable_eds:BuildPreReq: evolution-data-server-devel >= %eds_ver} libicu-devel
%{?_enable_introspection:BuildPreReq: gobject-introspection-devel libgtk+3-gir-devel}

%description
GNOME (GNU Network Object Model Environment) is a user-friendly
set of applications and desktop tools to be used in conjunction with a
window manager for the X Window System. GNOME is similar in purpose and
scope to CDE and KDE, but GNOME is based completely on free
software.

The GNOME panel packages provides the gnome panel, menu's and some
basic applets for the panel.

%package -n lib%name
Summary: GNOME panel shared libraries
License: LGPLv2+
Group: System/Libraries

%description -n lib%name
Panel shared libraries for creating GNOME panels.

%package -n lib%name-devel
Summary: GNOME panel libraries, includes, and more
License: LGPLv2+
Group: Development/GNOME and GTK+
Requires: lib%name = %version-%release

%description -n lib%name-devel
Panel libraries and header files for creating GNOME panels.

%package -n lib%name-devel-static
Summary: GNOME panel static libraries
Group: Development/GNOME and GTK+
Requires: lib%name-devel = %version-%release

%description -n lib%name-devel-static
Panel static libraries for creating GNOME panels.

%package -n lib%name-devel-doc
Summary: GNOME Panel development documentation
Group: Development/GNOME and GTK+
Conflicts: lib%name-devel < %version
BuildArch: noarch

%description -n lib%name-devel-doc
Development documentation for Gnome Panel Applet library.

%package -n lib%name-gir
Summary: GObject introspection data for the GNOME panel library
License: LGPLv2+
Group: System/Libraries

%description -n lib%name-gir
GObject introspection data for the GNOME Panel shared library.

%package -n lib%name-gir-devel
Summary: GObject introspection devel data for the GNOME panel library
License: LGPLv2+
Group: System/Libraries
BuildArch: noarch
Requires: lib%name-gir = %version-%release

%description -n lib%name-gir-devel
GObject introspection devel data for the GNOME Panel shared library.


%define gnome_appletsdir %_libdir/%name/modules
%define _gtk_docdir %_datadir/gtk-doc/html
#%%define _libexecdir %gnome_appletsdir

%prep
%setup

%build
%autoreconf
%configure \
    %{subst_enable static} \
    %{subst_enable eds} \
    --disable-schemas-compile \
    %{?_enable_gtk_doc:--enable-gtk-doc}
%make_build

%install
%makeinstall_std

%find_lang --with-gnome --output=%name.lang %name clock fish

%files -f %name.lang
%_bindir/gnome-desktop-item-edit
%_bindir/gnome-panel
%dir %gnome_appletsdir
%gnome_appletsdir/clock.so
%gnome_appletsdir/fish.so
%gnome_appletsdir/notification-area.so
%gnome_appletsdir/status-notifier.so
%gnome_appletsdir/wncklet.so
%dir %_datadir/gnome-panel
%_datadir/gnome-panel/*
%_desktopdir/%name.desktop
%_iconsdir/hicolor/*x*/apps/%{name}*.png
%_iconsdir/hicolor/scalable/apps/%{name}*.svg
%_man1dir/*
%config %_datadir/glib-2.0/schemas/*.xml
%doc AUTHORS NEWS README

%exclude %gnome_appletsdir/*.la

%files -n lib%name
%_libdir/*.so.*

%files -n lib%name-devel
%_includedir/*
%_libdir/*.so
%_pkgconfigdir/*

%files -n lib%name-devel-doc
%_gtk_docdir/*

%if_enabled static
%files -n lib%name-devel-static
%_libdir/*.a
%endif

%if_enabled introspection
%files -n lib%name-gir
%_typelibdir/*

%files -n lib%name-gir-devel
%_girdir/*
%endif

%changelog
