%def_disable snapshot

%define _unpackaged_files_terminate_build 1
%define xdg_name org.gnome.Photos
%define ver_major 3.24
%define _libexecdir %_prefix/libexec
%define gegl_api_ver 0.3

Name: gnome-photos
Version: %ver_major.4
Release: alt0.M80P.1

Summary: Photos - access, organize and share your photos on GNOME
License: %gpl2plus
Group: Graphics
Url: https://wiki.gnome.org/Apps/Photos

%if_disabled snapshot
Source: %gnome_ftp/%name/%ver_major/%name-%version.tar.xz
%else
Source: %name-%version.tar
%endif

%define glib_ver 2.44
%define gtk_ver 3.20.0
%define tracker_ver 0.18
%define gdata_ver 0.15.2
%define gegl_ver 0.3.14
%define grilo_ver 0.3
%define png_ver 1.5

Requires: grilo-plugins >= %grilo_ver

BuildPreReq: rpm-build-gnome rpm-build-licenses
# From configure.ac
BuildRequires: gnome-common intltool yelp-tools desktop-file-utils
BuildPreReq: libgio-devel >= %glib_ver
BuildPreReq: libgtk+3-devel >= %gtk_ver
BuildPreReq: tracker-devel >= %tracker_ver
BuildPreReq: libgdata-devel >= %gdata_ver
BuildPreReq: libgegl%gegl_api_ver-devel >= %gegl_ver
BuildPreReq: libgrilo-devel >= %grilo_ver
BuildPreReq: libpng-devel >= %png_ver
BuildRequires: libgexiv2-devel libexempi-devel liblcms2-devel librsvg-devel
BuildRequires: libjpeg-devel libgfbgraph-devel
BuildRequires: libgnome-desktop3-devel libgnome-online-accounts-devel zlib-devel
BuildRequires: libgeocode-glib-devel
BuildRequires: gobject-introspection-devel libgtk+3-gir-devel

%description
Photos, like Documents, Music and Videos, is one of the core GNOME
applications meant for find and reminding the user about her content.
The internal architecture Photos is based on Documents -- the document
manager application for GNOME, because they share similar UI/UX
patterns and objectives.

%prep
%setup
# downgrade required libpng
subst 's|libpng16|libpng15|' configure.ac

%{?_enable_snapshot:touch AUTHORS}

%build
%autoreconf
%configure \
    --disable-schemas-compile

%make_build

%install
%makeinstall_std
rm -rf %buildroot/%_datadir/doc/%name
%find_lang --with-gnome %name

%files -f %name.lang
%_bindir/%name
%_libexecdir/gnome-photos-thumbnailer
%_desktopdir/%xdg_name.desktop
%_iconsdir/hicolor/*/apps/%xdg_name.*
%_iconsdir/hicolor/scalable/apps/%xdg_name-symbolic.svg
%_datadir/appdata/%xdg_name.appdata.xml
%_datadir/gnome-shell/search-providers/%xdg_name.search-provider.ini
%_datadir/dbus-1/services/%xdg_name.service
%config %_datadir/glib-2.0/schemas/org.gnome.photos.gschema.xml
%doc ARTISTS AUTHORS NEWS README

%changelog
