%define ver_major 3.24
%define _libexecdir %_prefix/libexec
%def_enable systemd
%def_enable session_selector
%def_disable consolekit

Name: gnome-session
Version: %ver_major.2
Release: alt0.M80P.1

Summary: The gnome session programs for the GNOME GUI desktop environment
License: GPLv2+
Group: Graphical desktop/GNOME
URL: htpp://www.gnome.org

Source: %gnome_ftp/%name/%ver_major/%name-%version.tar.xz
#Source: %name-%version.tar
Source1: gnome.svg

# https://bugzilla.gnome.org/show_bug.cgi?id=775463
Patch: %name-2.91.6-alt-autosave_session.patch
Patch1: %name-3.21.4-alt-lfs.patch

# fedora patches:
# Blacklist NV30: https://bugzilla.redhat.com/show_bug.cgi?id=745202
Patch11: gnome-session-3.3.92-nv30.patch

# From configure.ac
%define glib_ver 2.46.0
%define gtk_ver 3.18.0
%define polkit_ver 0.91
%define upower_ver 0.9
%define systemd_ver 209

PreReq: xinitrc libcanberra-gnome libcanberra-gtk3
Requires: altlinux-freedesktop-menu-gnome3
Requires: dbus-tools-gui
Requires: gnome-filesystem
Requires: gnome-settings-daemon >= 3.23.90
Requires: upower gcr
Requires: xdg-user-dirs

Requires: icon-theme-hicolor gnome-icon-theme-symbolic gnome-themes-standard

BuildPreReq: rpm-build-gnome >= 0.5
BuildPreReq: gnome-common

# From configure.ac
BuildPreReq: intltool >= 0.35.0 libGConf-devel
BuildPreReq: libgio-devel glib2-devel >= %glib_ver
BuildPreReq: libgtk+3-devel >= %gtk_ver
# https://bugzilla.gnome.org/show_bug.cgi?id=710383
# BuildPreReq: libupower-devel >= %upower_ver
BuildRequires: libgnome-desktop3-devel librsvg-devel libjson-glib-devel
BuildRequires: libX11-devel libXau-devel libXrandr-devel libXrender-devel libXt-devel
BuildRequires: libSM-devel libXext-devel libXtst-devel libXi-devel libXcomposite-devel
BuildRequires: libGL-devel libGLES-devel
BuildRequires: GConf browser-plugins-npapi-devel perl-XML-Parser xorg-xtrans-devel
BuildRequires: docbook-dtds docbook-style-xsl
%{?_enable_systemd:BuildRequires: systemd-devel >= %systemd_ver libpolkit-devel}
%{?_enable_consolekit:BuildRequires: libdbus-glib-devel}
# since 3.22.2
BuildRequires: libepoxy-devel

%description
GNOME (GNU Network Object Model Environment) is a user-friendly set of
applications and desktop tools to be used in conjunction with a window
manager for the X Window System.

This package provides the GNOME session manager, as well as a
configuration program to choose applications starting on login.

%package selector
Summary: The session selector for the GNOME
Group: Graphical desktop/GNOME
Requires: %name = %EVR

%description selector
This package permits to choose a saved GNOME session.

%package wayland
Summary: A Wayland session for the GNOME
Group: Graphical desktop/GNOME
BuildArch: noarch
Requires: %name = %EVR
Requires: xorg-xwayland

%description wayland
This package permits to log into GNOME using Wayland.

%prep
%setup
#%patch1 -p1 -b .lfs
%patch11 -p1 -b .nv30

[ ! -d m4 ] && mkdir m4

%build
%autoreconf
%configure PATH=$PATH:/sbin \
    %{subst_enable systemd} \
    %{subst_enable consolekit} \
    %{?_enable_session_selector:--enable-session-selector} \
    --enable-ipv6 \
    --disable-schemas-compile

%make_build

%install
%makeinstall_std

%find_lang --with-gnome --output=%name.lang %name-3.0

%check
%make check

%files -f %name.lang
%_bindir/%name
%_bindir/%name-inhibit
%_bindir/%name-quit
%_libexecdir/%name-binary
%_libexecdir/%name-check-accelerated
%_libexecdir/%name-check-accelerated-gl-helper
%_libexecdir/%name-check-accelerated-gles-helper
%_libexecdir/%name-failed
%dir %_datadir/%name
%_datadir/%name/hardware-compatibility

%dir %_datadir/%name/sessions
%_datadir/%name/sessions/gnome.session
%_datadir/%name/sessions/gnome-dummy.session
%_datadir/xsessions/gnome.desktop
%_datadir/xsessions/gnome-xorg.desktop
%config %_datadir/glib-2.0/schemas/org.gnome.SessionManager.gschema.xml
%_datadir/GConf/gsettings/%name.convert
%_man1dir/%name-inhibit.*
%_man1dir/%name-quit.*
%_man1dir/%name.*
%doc AUTHORS NEWS README

%if_enabled session_selector
%files selector
%_bindir/%name-custom-session
%_bindir/%name-selector
%_datadir/%name/session-selector.ui
%_man1dir/%name-selector.*
%_datadir/xsessions/gnome-custom-session.desktop
%endif

%files wayland
%_datadir/wayland-sessions/gnome.desktop


%changelog
