%define ver_major 3.24
%define domain gcampax.github.com
%define _libexecdir %_prefix/libexec

Name: gnome-shell-extensions
Version: %ver_major.3
Release: alt0.M80P.1

Summary: GNOME Shell Extensions
Group: Graphical desktop/GNOME
License: GPLv2+
Url: https://wiki.gnome.org/Projects/GnomeShell

BuildArch: noarch

Source: ftp://ftp.gnome.org/pub/gnome/sources/%name/%ver_major/%name-%version.tar.xz

Requires: gnome-shell >= %ver_major

BuildRequires: gnome-common intltool libgnome-desktop3-devel libgtop-devel

%description
GNOME Shell Extensions is a collection of extensions providing additional
and optional functionality to GNOME Shell.
See %_docdir/%name-%version/README for more information.

%prep
%setup -n %name-%version

%build
#NOCONFIGURE=1 ./autogen.sh
%configure \
    --disable-schemas-compile \
    --enable-extensions=all
%make_build

%check
%make check

%install
%makeinstall_std

%find_lang %name

%files -f %name.lang
## Classic mode
%_datadir/gnome-session/sessions/gnome-classic.session
%_datadir/gnome-shell/modes/classic.json
%_datadir/gnome-shell/theme/calendar-today.svg
%_datadir/gnome-shell/theme/classic-toggle-off-intl.svg
%_datadir/gnome-shell/theme/classic-toggle-off-us.svg
%_datadir/gnome-shell/theme/classic-toggle-on-intl.svg
%_datadir/gnome-shell/theme/classic-toggle-on-us.svg
%_datadir/gnome-shell/theme/classic-process-working.svg
%_datadir/gnome-shell/theme/gnome-classic.css
%_datadir/gnome-shell/theme/gnome-classic-high-contrast.css
%_datadir/glib-2.0/schemas/org.gnome.shell.extensions.classic-overrides.gschema.xml
%_datadir/xsessions/gnome-classic.desktop

## Extensions
%dir %_datadir/gnome-shell/extensions
# alternate-tab
%dir %_datadir/gnome-shell/extensions/alternate-tab@gnome-shell-extensions.%domain
%_datadir/gnome-shell/extensions/alternate-tab@gnome-shell-extensions.%domain/extension.js
%_datadir/gnome-shell/extensions/alternate-tab@gnome-shell-extensions.%domain/metadata.json
%_datadir/gnome-shell/extensions/alternate-tab@gnome-shell-extensions.%domain/stylesheet.css
%_datadir/gnome-shell/extensions/alternate-tab@gnome-shell-extensions.%domain/convenience.js
%_datadir/gnome-shell/extensions/alternate-tab@gnome-shell-extensions.%domain/prefs.js

# windowsNavigator
%dir %_datadir/gnome-shell/extensions/windowsNavigator@gnome-shell-extensions.%domain
%_datadir/gnome-shell/extensions/windowsNavigator@gnome-shell-extensions.%domain/extension.js
%_datadir/gnome-shell/extensions/windowsNavigator@gnome-shell-extensions.%domain/metadata.json
%_datadir/gnome-shell/extensions/windowsNavigator@gnome-shell-extensions.%domain/stylesheet.css
%_datadir/gnome-shell/extensions/windowsNavigator@gnome-shell-extensions.%domain/convenience.js

# auto-move-windows
%dir %_datadir/gnome-shell/extensions/auto-move-windows@gnome-shell-extensions.%domain
%_datadir/gnome-shell/extensions/auto-move-windows@gnome-shell-extensions.%domain/extension.js
%_datadir/gnome-shell/extensions/auto-move-windows@gnome-shell-extensions.%domain/metadata.json
%_datadir/gnome-shell/extensions/auto-move-windows@gnome-shell-extensions.%domain/stylesheet.css
%_datadir/gnome-shell/extensions/auto-move-windows@gnome-shell-extensions.%domain/convenience.js
%_datadir/gnome-shell/extensions/auto-move-windows@gnome-shell-extensions.%domain/prefs.js
%_datadir/glib-2.0/schemas/org.gnome.shell.extensions.auto-move-windows.gschema.xml

# user theme loading
%dir %_datadir/gnome-shell/extensions/user-theme@gnome-shell-extensions.%domain
%_datadir/gnome-shell/extensions/user-theme@gnome-shell-extensions.%domain/extension.js
%_datadir/gnome-shell/extensions/user-theme@gnome-shell-extensions.%domain/metadata.json
%_datadir/gnome-shell/extensions/user-theme@gnome-shell-extensions.%domain/stylesheet.css
%_datadir/gnome-shell/extensions/user-theme@gnome-shell-extensions.%domain/convenience.js
%_datadir/glib-2.0/schemas/org.gnome.shell.extensions.user-theme.gschema.xml

# removable drives menu
%dir %_datadir/gnome-shell/extensions/drive-menu@gnome-shell-extensions.%domain
%_datadir/gnome-shell/extensions/drive-menu@gnome-shell-extensions.%domain/extension.js
%_datadir/gnome-shell/extensions/drive-menu@gnome-shell-extensions.%domain/metadata.json
%_datadir/gnome-shell/extensions/drive-menu@gnome-shell-extensions.%domain/stylesheet.css
%_datadir/gnome-shell/extensions/drive-menu@gnome-shell-extensions.%domain/convenience.js

# apps-menu
%dir %_datadir/gnome-shell/extensions/apps-menu@gnome-shell-extensions.%domain
%_datadir/gnome-shell/extensions/apps-menu@gnome-shell-extensions.%domain/extension.js
%_datadir/gnome-shell/extensions/apps-menu@gnome-shell-extensions.%domain/metadata.json
%_datadir/gnome-shell/extensions/apps-menu@gnome-shell-extensions.%domain/stylesheet.css
%_datadir/gnome-shell/extensions/apps-menu@gnome-shell-extensions.%domain/convenience.js

# native-window-placement
%dir %_datadir/gnome-shell/extensions/native-window-placement@gnome-shell-extensions.%domain
%_datadir/gnome-shell/extensions/native-window-placement@gnome-shell-extensions.%domain/extension.js
%_datadir/gnome-shell/extensions/native-window-placement@gnome-shell-extensions.%domain/metadata.json
%_datadir/gnome-shell/extensions/native-window-placement@gnome-shell-extensions.%domain/stylesheet.css
%_datadir/gnome-shell/extensions/native-window-placement@gnome-shell-extensions.%domain/convenience.js
%_datadir/glib-2.0/schemas/org.gnome.shell.extensions.native-window-placement.gschema.xml

# places-menu
%dir %_datadir/gnome-shell/extensions/places-menu@gnome-shell-extensions.%domain
%_datadir/gnome-shell/extensions/places-menu@gnome-shell-extensions.%domain/extension.js
%_datadir/gnome-shell/extensions/places-menu@gnome-shell-extensions.%domain/metadata.json
%_datadir/gnome-shell/extensions/places-menu@gnome-shell-extensions.%domain/stylesheet.css
%_datadir/gnome-shell/extensions/places-menu@gnome-shell-extensions.%domain/convenience.js
%_datadir/gnome-shell/extensions/places-menu@gnome-shell-extensions.%domain/placeDisplay.js

# workspace indicator
%dir %_datadir/gnome-shell/extensions/workspace-indicator@gnome-shell-extensions.%domain
%_datadir/gnome-shell/extensions/workspace-indicator@gnome-shell-extensions.%domain/extension.js
%_datadir/gnome-shell/extensions/workspace-indicator@gnome-shell-extensions.%domain/metadata.json
%_datadir/gnome-shell/extensions/workspace-indicator@gnome-shell-extensions.%domain/stylesheet.css
%_datadir/gnome-shell/extensions/workspace-indicator@gnome-shell-extensions.%domain/convenience.js
%_datadir/gnome-shell/extensions/workspace-indicator@gnome-shell-extensions.%domain/prefs.js

# launch-new-instance
%dir %_datadir/gnome-shell/extensions/launch-new-instance@gnome-shell-extensions.%domain
%_datadir/gnome-shell/extensions/launch-new-instance@gnome-shell-extensions.%domain/convenience.js
%_datadir/gnome-shell/extensions/launch-new-instance@gnome-shell-extensions.%domain/extension.js
%_datadir/gnome-shell/extensions/launch-new-instance@gnome-shell-extensions.%domain/metadata.json
%_datadir/gnome-shell/extensions/launch-new-instance@gnome-shell-extensions.%domain/stylesheet.css

# window-list
%dir %_datadir/gnome-shell/extensions/window-list@gnome-shell-extensions.%domain
%_datadir/gnome-shell/extensions/window-list@gnome-shell-extensions.%domain/classic.css
%_datadir/gnome-shell/extensions/window-list@gnome-shell-extensions.%domain/convenience.js
%_datadir/gnome-shell/extensions/window-list@gnome-shell-extensions.%domain/extension.js
%_datadir/gnome-shell/extensions/window-list@gnome-shell-extensions.%domain/metadata.json
%_datadir/gnome-shell/extensions/window-list@gnome-shell-extensions.%domain/prefs.js
%_datadir/gnome-shell/extensions/window-list@gnome-shell-extensions.%domain/stylesheet.css
%_datadir/glib-2.0/schemas/org.gnome.shell.extensions.window-list.gschema.xml

# screenshot-window-sizer
%dir %_datadir/gnome-shell/extensions/screenshot-window-sizer@gnome-shell-extensions.%domain
%_datadir/glib-2.0/schemas/org.gnome.shell.extensions.screenshot-window-sizer.gschema.xml
%_datadir/gnome-shell/extensions/screenshot-window-sizer@gnome-shell-extensions.%domain/convenience.js
%_datadir/gnome-shell/extensions/screenshot-window-sizer@gnome-shell-extensions.%domain/extension.js
%_datadir/gnome-shell/extensions/screenshot-window-sizer@gnome-shell-extensions.%domain/metadata.json
%_datadir/gnome-shell/extensions/screenshot-window-sizer@gnome-shell-extensions.%domain/stylesheet.css

%doc README

# example
%exclude %_datadir/gnome-shell/extensions/example@gnome-shell-extensions.%domain/
%exclude %_datadir/glib-2.0/schemas/org.gnome.shell.extensions.example.gschema.xml

%if 0
# xrandr-indicator incompatible with the new DisplayConfig mutter API
%dir %_datadir/gnome-shell/extensions/xrandr-indicator@gnome-shell-extensions.%domain
%_datadir/gnome-shell/extensions/xrandr-indicator@gnome-shell-extensions.%domain/extension.js
%_datadir/gnome-shell/extensions/xrandr-indicator@gnome-shell-extensions.%domain/metadata.json
%_datadir/gnome-shell/extensions/xrandr-indicator@gnome-shell-extensions.%domain/stylesheet.css
%_datadir/gnome-shell/extensions/xrandr-indicator@gnome-shell-extensions.%domain/convenience.js
%endif

%changelog
