%define ver_major 3.24
%define plugins_ver 11
%define _libexecdir %_prefix/libexec
%define xdg_name org.gnome.Software

%def_enable gtkspell
%def_enable gudev
%def_enable gnome_desktop
%def_enable polkit
%def_disable firmware
%def_enable flatpak
%def_disable ostree
%def_disable limba
%def_disable packagekit
%def_enable webapps
%def_enable odrs
%def_disable tests

Name: gnome-software
Version: %ver_major.3
Release: alt1.M80P.1

Summary: Software manager for GNOME
License: GPLv2+
Group: Graphical desktop/GNOME
Url: https://wiki.gnome.org/Apps/Software

Source: ftp://ftp.gnome.org/pub/gnome/sources/%name/%ver_major/%name-%version.tar.xz

%define glib_ver 2.46
%define gtk_ver 3.20
%define appstream_glib_ver 0.6.5
%define json_glib_ver 1.1.1
%define soup_ver 2.52
%define packagekit_ver 1.1.0
%define gnome_desktop_ver 3.18
%define fwupd_ver 0.7.0
%define flatpak_ver 0.6.12
%define limba_ver 0.5.6

BuildRequires: libgio-devel >= %glib_ver
BuildRequires: libgtk+3-devel >= %gtk_ver
BuildRequires: libappstream-glib-devel >= %appstream_glib_ver
BuildRequires: libjson-glib-devel >= %json_glib_ver
BuildRequires: libsoup-devel >= %soup_ver
BuildRequires: gnome-common rpm-build-xdg intltool yelp-tools gtk-doc xsltproc docbook-style-xsl
BuildRequires: libsqlite3-devel libsecret-devel gsettings-desktop-schemas-devel
BuildRequires: librpm-devel valgrind-tool-devel
%{?_enable_gudev:BuildRequires: libgudev-devel}
%{?_enable_gtkspell:BuildRequires: libgtkspell3-devel}
%{?_enable_gnome_desktop:BuildRequires: libgnome-desktop3-devel >= %gnome_desktop_ver}
%{?_enable_polkit:BuildRequires: libpolkit-devel}
%{?_enable_firmware:BuildRequires: libfwupd-devel >= %fwupd_ver}
%{?_enable_flatpak:BuildRequires: libflatpak-devel >= %flatpak_ver}
%{?_enable_ostree:BuildRequires: libostree-devel >= %flatpak_ver}
%{?_enable_limba:BuildRequires: liblimba-devel >= %limba_ver}
%{?_enable_packagekit:BuildRequires: libpackage-kit-devel >= %packagekit_ver}

%description
GNOME Software is for installing, removing and updating software.

%package devel
Summary: Development files for GNOME Software
Group: Development/GNOME and GTK+
Requires: %name = %version-%release

%description devel
This package contains files necessary to develop plugins for GNOME
Software.

%package devel-doc
Summary: Development documentation for GNOME Software
Group: Development/GNOME and GTK+
BuildArch: noarch
Conflicts: %name-devel < %version

%description devel-doc
This package contains documentation necessary to develop plugins for
GNOME Software.


%prep
%setup

%build
%configure \
	--disable-static \
	--disable-schemas-compile \
	%{subst_enable gtkspell} \
	%{subst_enable gudev} \
	%{?_enable_gnome_desktop:--enable-gnome-desktop} \
	%{subst_enable polkit} \
	%{subst_enable firmware} \
	%{subst_enable flatpak} \
	%{subst_enable ostree} \
	%{subst_enable limba} \
	%{subst_enable packagekit} \
	%{subst_enable tests}
%make_build

%install
%makeinstall_std

%find_lang --with-gnome %name

%files -f %name.lang
%_xdgconfigdir/autostart/%name-service.desktop
%_bindir/%name
%_libexecdir/gnome-software-cmd
%_libexecdir/gnome-software-restarter
%_libdir/gs-plugins-%plugins_ver/
%_desktopdir/%name-local-file.desktop
%_desktopdir/%xdg_name.desktop
%_datadir/dbus-1/services/%xdg_name.service
%_datadir/%name/
%_datadir/gnome-shell/search-providers/%xdg_name-search-provider.ini
%_iconsdir/hicolor/*x*/*/%xdg_name.png
%_iconsdir/hicolor/scalable/apps/%xdg_name-symbolic.svg
%_iconsdir/hicolor/scalable/apps/software-installed-symbolic.svg
%_datadir/glib-2.0/schemas/org.gnome.software.gschema.xml
%_datadir/appdata/%xdg_name.appdata.xml
%_datadir/appdata/%xdg_name.Plugin.Epiphany.metainfo.xml
%_datadir/appdata/%xdg_name.Plugin.Flatpak.metainfo.xml
%_datadir/appdata/%xdg_name.Plugin.Odrs.metainfo.xml
%_datadir/appdata/%xdg_name.Plugin.Steam.metainfo.xml
%_man1dir/%name.1.*
%doc AUTHORS README NEWS

%files devel
%_includedir/%name/
%_pkgconfigdir/%name.pc

%files devel-doc
%_datadir/gtk-doc/html/%name/

%changelog
