%define _unpackaged_files_terminate_build 1
%define ver_major 3.24
%define xdg_name org.gnome.SoundRecorder
%define gst_api_ver 1.0

Name: gnome-sound-recorder
Version: %ver_major.0
Release: alt0.M80P.1

Summary: Sound Recorder for GNOME
Group: Sound
License: GPLv2+
Url: https://wiki.gnome.org/Design/Apps/SoundRecorder

Source: ftp://ftp.gnome.org/pub/gnome/sources/%name/%ver_major/%name-%version.tar.xz

BuildArch: noarch

Obsoletes: gnome-media-common
Obsoletes: gnome-media-grecord
Provides:  gnome-media-grecord = %version-%release

%define glib_ver 2.31.10
%define gtk_ver 3.10.8
%define gjs_ver 1.41

Requires: libgjs >= 1.41
Requires: gst-plugins-base%gst_api_ver gst-plugins-good%gst_api_ver gst-plugins-bad%gst_api_ver
Requires: gstreamer%gst_api_ver-utils
# find ./ -name "*.js" |/usr/lib/rpm/gir-js.req |sort|uniq|sed -e 's/^/Requires: /'
Requires: typelib(GLib)
Requires: typelib(GObject)
Requires: typelib(Gdk)
Requires: typelib(GdkPixbuf)
Requires: typelib(Gio)
Requires: typelib(Gst)
Requires: typelib(GstAudio)
Requires: typelib(GstPbutils)
Requires: typelib(Gtk)
Requires: typelib(Pango)
# explicitly required to avoid installation old version
Requires: libgst-plugins%gst_api_ver-gir

BuildRequires: gnome-common libgio-devel >= %glib_ver libgtk+3-devel >= %gtk_ver
BuildRequires: libgjs-devel libgtk+3-gir-devel intltool yelp-tools
BuildRequires: gst-plugins%gst_api_ver-devel
BuildRequires: gstreamer%gst_api_ver-utils gst-plugins-base%gst_api_ver
BuildRequires: gst-plugins-good%gst_api_ver gst-plugins-bad%gst_api_ver

%description
The GNOME application for record and play sound files.

%prep
%setup

%build
%autoreconf
%configure \
	--disable-schemas-compile

%make_build

%install
%makeinstall_std

%find_lang --with-gnome --output=%name.lang %name

%files -f %name.lang
%_bindir/%name
%_datadir/%name/
%_datadir/applications/%xdg_name.desktop
%_datadir/glib-2.0/schemas/org.gnome.%name.gschema.xml
%_iconsdir/hicolor/*/apps/*
%_datadir/appdata/%xdg_name.appdata.xml
%doc NEWS README


%changelog
