%define _unpackaged_files_terminate_build 1

%define ver_major 3.24
%def_enable systemd
%def_enable wnck

%define _libexecdir %_prefix/libexec

Name: gnome-system-monitor
Version: %ver_major.0
Release: alt0.M80P.1

Summary: Simple process monitor
License: GPLv2+
Group: Monitoring
Url: https://wiki.gnome.org/Apps/SystemMonitor

Source: %gnome_ftp/%name/%ver_major/%name-%version.tar.xz

%define glib_ver 2.38
%define gtk_ver 3.12
%define glibmm_ver 2.28.0
%define libgtkmm3_ver 3.0.0
%define libwnck_ver 3.0.0
%define libgtop_ver 2.28.2
%define libxml_ver 2.0
%define rsvg_ver 2.35
%define gnome_icon_theme_ver 3.0.0
%define systemd_ver 44

BuildPreReq: rpm-build-gnome
BuildRequires: gcc-c++ gnome-common libappstream-glib-devel
BuildRequires: intltool yelp-tools
BuildPreReq: libgio-devel >= %glib_ver
BuildPreReq: libglibmm-devel >= %glibmm_ver
BuildPreReq: libgtk+3-devel >= %gtk_ver
BuildPreReq: libgtkmm3-devel >= %libgtkmm3_ver
BuildPreReq: libgtop-devel >= %libgtop_ver
BuildPreReq: gnome-icon-theme >= %gnome_icon_theme_ver
BuildPreReq: libxml2-devel >= %libxml_ver
BuildPreReq: librsvg-devel >= %rsvg_ver

%{?_enable_wnck:BuildPreReq: libwnck3-devel >= %libwnck_ver}
%{?_enable_systemd:BuildRequires: systemd-devel libsystemd-devel}

%description
Gnome-system-monitor is a simple process and system monitor.

%prep
%setup

%build
%autoreconf
%configure \
    --disable-schemas-compile \
    %{subst_enable systemd} \
    %{subst_enable wnck}
%make_build

%install
%makeinstall_std

%find_lang --with-gnome %name

%files -f %name.lang
%_bindir/*
%dir %_libexecdir/%name
%_libexecdir/%name/gsm-kill
%_libexecdir/%name/gsm-renice
%_desktopdir/*
%_datadir/polkit-1/actions/org.gnome.%name.policy
%config %_datadir/glib-2.0/schemas/org.gnome.%name.gschema.xml
%config %_datadir/glib-2.0/schemas/org.gnome.%name.enums.xml
%_datadir/appdata/%name.appdata.xml


%changelog
