%define _name gnome-themes
%define ver_major 2.32

Name: %_name-default
Version: %ver_major.1
Release: alt1

Summary: A set of default themes for GNOME 2 desktop
License: LGPL
Group: Graphical desktop/GNOME
Url: http://www.gnome.org
Packager: GNOME Maintainers Team <gnome at packages.altlinux.org>

Source: ftp://ftp.gnome.org/pub/gnome/sources/%_name/%ver_major/%_name-%version.tar.bz2

%undefine _configure_target
BuildArch: noarch

%define icon_theme icon-theme
%define old_icon_theme gnome-icon-theme
%define icon_theme_namechange_ver 2.16.1.1-alt4

%define theme_prefix gnome-theme
%define old_theme_prefix gtk2-themes
%define namechange_ver 2.16.1.1
%define gtk_theme_prefix gtk2-theme

%define metacity_theme_prefix metacity-theme
%define old_metacity_theme_prefix metacity-themes

Requires: %icon_theme-crux = %version-%release
Requires: %icon_theme-mist = %version-%release
Requires: %{icon_theme}s-accessibility = %version-%release
Requires: %{theme_prefix}s-accessibility = %version-%release
Requires: %theme_prefix-crux = %version-%release
Requires: %theme_prefix-glider = %version-%release
Requires: %theme_prefix-mist = %version-%release
Requires: %theme_prefix-clearlooks = %version-%release
Requires: %theme_prefix-glossy = %version-%release
Requires: %gtk_theme_prefix-simple = %version-%release

# From configure.in
%define gtk_engines_ver 2.17.1
%define icon_theme_ver 2.24.0

BuildPreReq: intltool >= 0.35.0
BuildPreReq: libgtk+2-devel
# libgtk-engines-devel only appeared in 2.8.0-alt3, actually; it was named
# gtk-engines-default-devel, but to force apt to choose the new package, we
# use the new name.
BuildPreReq: libgtk-engines-devel >= %gtk_engines_ver
BuildPreReq: icon-naming-utils >= 0.8.0

BuildRequires: gnome-common perl-XML-Parser

%description
This package provides a set of default themes for GNOME 2 desktop.

%package common
Summary: Common files for GNOME default themes
Group: Graphical desktop/GNOME
BuildArch: noarch
Obsoletes: %old_theme_prefix-common < %namechange_ver
Provides: %old_theme_prefix-common = %version-%release
Obsoletes: gnome-themes-common < 2.16.1.1-alt3

%description common
This package contains common files needed to use GNOME default themes.

%package -n %{gtk_theme_prefix}s-accessibility
Summary: Accessibility themes for GTK+2
Group: Graphical desktop/GNOME
Requires: %name-common = %version-%release
Requires: libgtk-engine-hc >= %gtk_engines_ver

%description -n %{gtk_theme_prefix}s-accessibility
This package provides accessibility themes for GTK+2.

%package -n %{theme_prefix}s-accessibility
Summary: Accessibility themes for GNOME 2
Group: Graphical desktop/GNOME
Obsoletes: %old_theme_prefix-accessibility < %namechange_ver
Provides: %old_theme_prefix-accessibility = %version-%release

Requires: %name-common = %version-%release
Requires: %{gtk_theme_prefix}s-accessibility = %version-%release

%description -n %{theme_prefix}s-accessibility
This package provides accessibility themes for GNOME 2.

%package -n %theme_prefix-crux
Summary: A theme for GNOME 2
Group: Graphical desktop/GNOME
Obsoletes: %old_theme_prefix-Crux < %namechange_ver
Provides: %old_theme_prefix-Crux = %version-%release

Requires: %name-common = %version-%release
Requires: %gtk_theme_prefix-crux
Requires: %old_icon_theme-crux
Requires: metacity-theme-crux >= 2.28

%description -n %theme_prefix-crux
This package contains Crux - a GNOME 2 theme developed by Eazel, Inc.

%package -n %theme_prefix-mist
Summary: A theme for Metacity and GNOME 2
Group: Graphical desktop/GNOME
Obsoletes: %old_theme_prefix-Mist < %namechange_ver
Provides: %old_theme_prefix-Mist = %version-%release

Provides: %metacity_theme_prefix-mist = %version-%release
Provides: metacity-theme = %version-%release

Requires: %name-common = %version-%release
Requires: %gtk_theme_prefix-mist
Requires: %old_icon_theme-mist >= %icon_theme_ver
Requires: %metacity_theme_prefix-mist

%description -n %theme_prefix-mist
Author named this after the song he was listening to when he named it
(Opeth's "In Mist She Was Standing").
This package provides a window decoration for Metacity and a preset for
GNOME 2 theme switcher.

%package -n %gtk_theme_prefix-glider
Summary: A theme for GTK+2
Group: Graphical desktop/GNOME
Requires: libgtk-engine-glide >= %gtk_engines_ver

%description -n %gtk_theme_prefix-glider
This package provides Glider theme for GTK+2.

%package -n %gtk_theme_prefix-ClearlooksClassic
Summary: A theme for GTK+2
Group: Graphical desktop/GNOME
Requires: %gtk_theme_prefix-clearlooks >= %gtk_engines_ver

%description -n %gtk_theme_prefix-ClearlooksClassic
This package provides classic Clearlooks theme for GTK+2.

%package -n %theme_prefix-glider
Summary: A theme for GNOME 2, and Metacity
Group: Graphical desktop/GNOME
Obsoletes: %old_theme_prefix-Glider < %namechange_ver
Provides: %old_theme_prefix-Glider = %version-%release
Obsoletes: %old_metacity_theme_prefix-glider < %namechange_ver
Provides: %old_metacity_theme_prefix-glider = %version-%release

Provides: %metacity_theme_prefix-glider = %version-%release
Provides: metacity-theme = %version-%release

Requires: %name-common = %version-%release
Requires: %gtk_theme_prefix-glider = %version-%release
Requires: gnome-%icon_theme >= %icon_theme_ver
Requires: %metacity_theme_prefix-glider

%description -n %theme_prefix-glider
This package provides Glider themes: a window decoration for Metacity, and a preset for GNOME 2 theme switcher.

%package -n %theme_prefix-clearlooks
Summary: A theme for GNOME and Metacity
Group: Graphical desktop/GNOME
Obsoletes: %old_theme_prefix-Clearlooks < %namechange_ver
Provides: %old_theme_prefix-Clearlooks = %version-%release
Obsoletes: %old_metacity_theme_prefix-clearlooks < %namechange_ver
Provides: %old_metacity_theme_prefix-clearlooks = %version-%release

Provides: %metacity_theme_prefix-clearlooks = %version-%release
Provides: %metacity_theme_prefix-ClearlooksClassic = %version-%release
Provides: metacity-theme = %version-%release

Requires: %name-common = %version-%release
Requires: gnome-%icon_theme >= %icon_theme_ver
Requires: %gtk_theme_prefix-clearlooks >= %gtk_engines_ver
Requires: %gtk_theme_prefix-ClearlooksClassic = %version-%release
Requires: %metacity_theme_prefix-clearlooks

%description -n %theme_prefix-clearlooks
Clearlooks is the official default theme of GNOME 2.12-2.16.
This package provides a window decoration for Metacity and a preset for
GNOME 2 theme switcher.

%package -n %gtk_theme_prefix-glossy
Summary: A Clearlooks-based theme for GTK+ applications
Group: Graphical desktop/GNOME
Requires: libgtk-engine-clearlooks >= %gtk_engines_ver

%description -n %gtk_theme_prefix-glossy
This package contains Glossy theme for GTK+ applications. Note: if you want to
have Glossy window decoration or GNOME theme, you should install
%theme_prefix-glossy package.

%package -n %theme_prefix-glossy
Summary: A Clearlooks-based theme for GNOME
Group: Graphical desktop/GNOME
Requires: metacity
Provides: %metacity_theme_prefix-glossy = %version-%release
Provides: metacity-theme = %version-%release
Requires: libgnome
Requires: %gtk_theme_prefix-glossy >= %gtk_engines_ver
Requires: gnome-icon-theme >= %icon_theme_ver

%description -n %theme_prefix-glossy
This package provides Glossy theme (a preset for GNOME 2 theme switcher).

%package -n %gtk_theme_prefix-simple
Summary: A theme for GTK+2
Group: Graphical desktop/GNOME
Obsoletes: %old_theme_prefix-Simple < %namechange_ver
Provides: %old_theme_prefix-Simple = %version-%release
Requires: libgtk-engine-glide >= %gtk_engines_ver

%description -n %gtk_theme_prefix-simple
This package provides a Simple theme for GTK+2.

%package -n %{icon_theme}s-accessibility
Summary: Accessibility icon themes for fd.o compliant graphical environments
Group: Graphical desktop/GNOME
Requires: %name-common = %version-%release

%description -n %{icon_theme}s-accessibility
This package provides a set of icon themes designed for accessibility.

%package -n %icon_theme-crux
Summary: A Crux icon theme
Group: Graphical desktop/GNOME
Requires: %name-common = %version-%release
Obsoletes: %old_icon_theme-crux < %icon_theme_namechange_ver
Provides: %old_icon_theme-crux = %version-%release

%description -n %icon_theme-crux
This package provides a Crux icon theme.

%package -n %icon_theme-mist
Summary: A Mist icon theme
Group: Graphical desktop/GNOME
Requires: %name-common = %version-%release
Obsoletes: %old_icon_theme-mist < %icon_theme_namechange_ver
Provides: %old_icon_theme-mist = %version-%release

%description -n %icon_theme-mist
This package provides a Mist icon theme.

%prep
%setup -q -n %_name-%version

%__subst 's,\$2/\(\$ORIG_FILE\),\1,' common/mkiconlinks.sh

%build
%configure \
	--enable-all-themes \
	--disable-placeholders \
	--enable-icon-mapping \
	--disable-test-themes

%make_build

%install
%make DESTDIR=%buildroot install

find %buildroot%_iconsdir -name "index.theme" -print0|\
xargs -r0 %__subst 's|\(Inherits=.*$\)|\1,hicolor,default.kde|' --

%find_lang %_name

%files

%files common -f %_name.lang
%doc README ChangeLog AUTHORS

%files -n %{gtk_theme_prefix}s-accessibility
%dir %_datadir/themes/HighContrast*
%dir %_datadir/themes/HighContrast*/gtk-2.0
%_datadir/themes/HighContrast*/gtk-2.0/gtkrc
%dir %_datadir/themes/HighContrast*/pixmaps
%_datadir/themes/HighContrast*/pixmaps/*.png
%_datadir/themes/HighContrast*/pixmaps/*.xpm
%dir %_datadir/themes/LowContrast*
%dir %_datadir/themes/LowContrast*/gtk-2.0
%_datadir/themes/LowContrast*/gtk-2.0/gtkrc
%dir %_datadir/themes/LowContrast*/pixmaps
%_datadir/themes/LowContrast*/pixmaps/*.png
%_datadir/themes/LowContrast*/pixmaps/*.xpm
%dir %_datadir/themes/LargePrint*
%dir %_datadir/themes/LargePrint*/gtk-2.0
%_datadir/themes/LargePrint*/gtk-2.0/gtkrc
%dir %_datadir/themes/Inverted/gtk-2.0
%_datadir/themes/Inverted/gtk-2.0/gtkrc

%exclude %_datadir/themes/LowContrast/index.theme

%files -n %{theme_prefix}s-accessibility
%_datadir/themes/HighContrast*/index.theme
#%_datadir/themes/HighContrast*/index.theme.disabled
%_datadir/themes/LowContrast/index.theme
%_datadir/themes/LowContrast*/index.theme
%_datadir/themes/LargePrint*/index.theme
%_datadir/themes/Inverted/metacity-1/metacity-theme-1.xml

%files -n %gtk_theme_prefix-ClearlooksClassic
%dir %_datadir/themes/ClearlooksClassic/gtk-2.0
%_datadir/themes/ClearlooksClassic/gtk-2.0/gtkrc

%files -n %gtk_theme_prefix-glider
%dir %_datadir/themes/Glider
%dir %_datadir/themes/Glider/gtk-2.0
%_datadir/themes/Glider/gtk-2.0/gtkrc

%files -n %theme_prefix-glider
%dir %_datadir/themes/Glider/metacity-1
%_datadir/themes/Glider/metacity-1/metacity-theme-1.xml
%_datadir/themes/Glider/index.theme

%files -n %theme_prefix-crux
%_datadir/themes/Crux/index.theme

%files -n %theme_prefix-mist
%dir %_datadir/themes/Mist/metacity-1
%_datadir/themes/Mist/metacity-1/metacity-theme-1.xml
%_datadir/themes/Mist/index.theme

%files -n %theme_prefix-clearlooks
%dir %_datadir/themes/Clearlooks/metacity-1
%_datadir/themes/Clearlooks/metacity-1/metacity-theme-1.xml
%_datadir/themes/Clearlooks/index.theme
# Clearlooks Classic
%dir %_datadir/themes/ClearlooksClassic/metacity-1
%_datadir/themes/ClearlooksClassic/metacity-1/metacity-theme-1.xml

%files -n %gtk_theme_prefix-glossy
%dir %_datadir/themes/Glossy
%dir %_datadir/themes/Glossy/gtk-2.0
%_datadir/themes/Glossy/gtk-2.0/gtkrc

%files -n %theme_prefix-glossy
%dir %_datadir/themes/Glossy/metacity-1
%_datadir/themes/Glossy/metacity-1/metacity-theme-1.xml
%_datadir/themes/Glossy/index.theme

%files -n %gtk_theme_prefix-simple
%dir %_datadir/themes/Simple
%dir %_datadir/themes/Simple/gtk-2.0
%_datadir/themes/Simple/gtk-2.0/gtkrc

%files -n %{icon_theme}s-accessibility
%dir %_iconsdir/HighContrast*
%dir %_iconsdir/HighContrast*/*x*
%dir %_iconsdir/HighContrast*/*x*/*
%_iconsdir/HighContrast*/*x*/*/*.png
%_iconsdir/HighContrast*/*x*/*/*.icon

%dir %_iconsdir/HighContrast-SVG/scalable
%dir %_iconsdir/HighContrast-SVG/scalable/*
%_iconsdir/HighContrast-SVG/scalable/*/*.svg
%dir %_iconsdir/LargePrint
%_iconsdir/LargePrint/index.theme

%files -n %icon_theme-crux
%dir %_iconsdir/Crux
%dir %_iconsdir/Crux/*x*
%dir %_iconsdir/Crux/*x*/*
%_iconsdir/Crux/*x*/*/*.png
%dir %_iconsdir/Crux/scalable
%dir %_iconsdir/Crux/scalable/*
%_iconsdir/Crux/scalable/*/*.svg

%files -n %icon_theme-mist
%dir %_iconsdir/Mist
%dir %_iconsdir/Mist/*x*
%dir %_iconsdir/Mist/*x*/*
%_iconsdir/Mist/*x*/*/*.png
#%_iconsdir/Mist/*x*/*/*.svg
#%dir %_iconsdir/Mist/scalable
#%dir %_iconsdir/Mist/scalable/*
#%_iconsdir/Mist/scalable/*/*.svg
%_iconsdir/Mist/index.theme

%changelog
