%def_disable snapshot
%define _libexecdir %_prefix/libexec
%define ver_major 3.24

Name: gnome-tweak-tool
Version: %ver_major.1
Release: alt0.M80P.1

Summary: A tool to customize advanced GNOME 3 options
Group: Graphical desktop/GNOME
License: GPLv3
Url: https://wiki.gnome.org/Apps/GnomeTweakTool

%if_enabled snapshot
Source: %name-%version.tar
%else
Source: ftp://ftp.gnome.org/pub/gnome/sources/%name/%ver_major/%name-%version.tar.xz
%endif
Patch: gnome-tweak-tool-3.8.0-alt-desktop.patch

BuildArch: noarch
Requires: gnome-shell >= %ver_major

BuildRequires: gnome-common intltool libgio-devel libgtk+3-devel >= 3.12.0
BuildRequires: gsettings-desktop-schemas-devel >= 3.24.0
BuildRequires: python-module-pygobject3-devel >= 3.10.0

%description
GNOME Tweak Tool is an application for changing the advanced settings
of GNOME 3.

Features:
* Install and switch gnome-shell themes
* Switch GTK+ themes
* Switch icon themes
* Change
  - The user-interface and title bar fonts
  - Icons in menus and buttons
  - Behavior on laptop lid close
  - Shell font size
  - File manager desktop icons
  - Title bar click action
  - Shell clock to show date
  - Font hinting
  - Font anti-aliasing

%prep
%setup
%patch -b .desktop

%build
%{?_enable_snapshot:NOCONFIGURE=1 ./autogen.sh}
%configure --disable-schemas-compile
%make_build

%install
%makeinstall_std

%find_lang %name

%files -f %name.lang
%_bindir/%name
%_libexecdir/%name-lid-inhibitor
%python_sitelibdir/gtweak
%_datadir/applications/%name.desktop
%_datadir/%name
%_iconsdir/hicolor/*/*/*.png
%_iconsdir/hicolor/*/*/*.svg
%_datadir/appdata/%name.appdata.xml
%doc AUTHORS NEWS README

%changelog
