%define xdg_name org.gnome.Weather
%define ver_major 3.24
%define _libexecdir %_prefix/libexec

Name: gnome-weather
Version: %ver_major.0
Release: alt0.M80P.1

Summary: Access current weather conditions and forecasts
Group: Graphical desktop/GNOME
License: GPLv3+
Url: https://live.gnome.org/Design/Apps/Weather

#Source: %name-%version.tar
Source: %gnome_ftp/%name/%ver_major/%name-%version.tar.xz

BuildArch: noarch

Obsoletes: %name-data
Provides:  %name-data = %version-%release

%define gtk_ver 3.12
%define gi_ver 1.36.0
%define gjs_ver 1.40.0
%define gweather_ver 3.20.2

Requires: libgweather-gir >= %gweather_ver
# find ./ -name "*.js" |/usr/lib/rpm/gir-js.req |sort|uniq|sed -e 's/^/Requires: /'
Requires: typelib(Gdk)
Requires: typelib(Geoclue)
Requires: typelib(Gio)
Requires: typelib(GLib)
Requires: typelib(GnomeDesktop)
Requires: typelib(GObject)
Requires: typelib(Gtk)
Requires: typelib(GWeather)

BuildRequires: rpm-build-gnome gnome-common intltool rpm-build-gir
BuildRequires: libgtk+3-devel >= %gtk_ver libgjs-devel >= %gjs_ver
BuildRequires: libgweather-devel >= %gweather_ver libgeoclue2-devel
BuildRequires: gobject-introspection-devel >= %gi_ver libgtk+3-gir-devel libgweather-gir-devel
BuildRequires: libappstream-glib-devel

%description
%name is a small application that allows you to monitor the current
weather conditions for your city, or anywhere in the world, and to
access updated forecasts provided by various internet services.


%prep
%setup
[ ! -d m4 ] && mkdir m4
subst 's@\$(LN_S)@ln -s@' src/Makefile.am

%build
%autoreconf
%configure \
	--disable-schemas-compile

%make_build

%install
%makeinstall_std

%find_lang --with-gnome %xdg_name

%files -f %xdg_name.lang
%_bindir/%name
%_datadir/applications/%xdg_name.Application.desktop
%_datadir/%xdg_name/
%_datadir/dbus-1/services/%xdg_name.Application.service
%_datadir/dbus-1/services/%xdg_name.BackgroundService.service
%_datadir/glib-2.0/schemas/%xdg_name.Application.gschema.xml
%_iconsdir/hicolor/*/apps/%xdg_name.png
%_iconsdir/hicolor/symbolic/apps/%xdg_name-symbolic.svg
%_datadir/gnome-shell/search-providers/%xdg_name.Application.search-provider.ini
%_datadir/appdata/%xdg_name.appdata.xml
%doc NEWS

%changelog
