%define orig_name GNS3
Name: gns3
Version: 0.8.6
Release: alt1

Summary: GNS-3  is a graphical network simulator

License: GPL
Group: File tools
Url: http://www.gns3.net/

Packager: Ilya Mashkin <oddity@altlinux.ru>

Source0: %name-%version.tar
Patch: %name-%version-alt.patch

BuildArch: noarch
Requires: python-module-sip dynamips

BuildRequires: python-devel

%description
GNS3 is a graphical network simulator that allows you to design
complex network topologies. You may run simulations or configure
devices ranging from simple workstations to powerful Cisco and Juniper
routers. It is based on Dynamips, an IOS emulator which allows users
to run IOS binary images from Cisco Systems, Pemu, an PIX firewall
emulator, Qemu and VirtualBox.

See 'virtualbox' and 'qemu' subpackages for guest support.

%package -n python-module-virtualbox
Summary: VirtualBox management support for python
Group: File tools
Requires: virtualbox-sdk

%description -n python-module-virtualbox
VirtualBox management support for python

%package virtualbox
Summary: VirtualBox guest support for GNS3
Group: File tools
Requires: %name = %version
Requires: python-module-virtualbox

%description virtualbox
VirtualBox guest support for GNS3

%package qemu
Summary: Qemu guest support for GNS3
Group: File tools
Requires: %name = %version
Requires: qemu-system

%description qemu
Qemu guest support for GNS3

%prep
%setup
%patch -p1

subst 's|/usr/local/share|/usr/share|g' setup.py

%build
%python_build

%install
python setup.py install --root %buildroot
mkdir -p %buildroot/%_man1dir
install -m 0644 docs/man/gns3.1 %buildroot/%_man1dir

#desktop
install -d %buildroot/%_desktopdir
install -m 0644 %name.desktop %buildroot/%_desktopdir/%name.desktop

# icons
install -d %buildroot/%_miconsdir
install -d %buildroot/%_niconsdir
install -d %buildroot/%_liconsdir
cp icons/mini/*.xpm %buildroot/%_miconsdir
cp icons/*.xpm %buildroot/%_niconsdir
cp icons/large/*.xpm %buildroot/%_liconsdir

# virtualbox
install -d %buildroot/%python_sitelibdir
install -m 0644 virtualbox.pth %buildroot/%python_sitelibdir/virtualbox.pth

%files
%doc baseconfig*txt AUTHORS CHANGELOG README TODO COPYING
%dir %_datadir/gns3
%_bindir/gns3*
%python_sitelibdir/GNS3*
%_man1dir/*
%_desktopdir/%name.desktop
%_miconsdir/*.xpm
%_niconsdir/*.xpm
%_liconsdir/*.xpm

%files -n python-module-virtualbox
%python_sitelibdir/virtualbox.pth

%files virtualbox
%_datadir/gns3/vboxcontroller_4_1.py
%_datadir/gns3/vboxwrapper.py
%_datadir/gns3/tcp_pipe_proxy.py

%files qemu
%_datadir/gns3/qemuwrapper.py

%changelog
