Name: gnulib
Version: 0.1.1213.683b6
Release: alt1

Summary: GNU Portability Library
License: Freely distributable
Group: Development/C
BuildArch: noarch
Url: http://www.gnu.org/software/gnulib/
Source: %name-%version.tar
Patch1: gnulib-alt-utimens.patch
Patch2: gnulib-alt-mktime-internal.patch
AutoReqProv: no
BuildRequires: gnu-config makeinfo

%description
Gnulib is intended to be the canonical source for most of the important
"portability" and/or common files for GNU projects.  These are files
intended to be shared at the source level; Gnulib is not a typical
library meant to be installed and linked against.  Thus, unlike most
projects, Gnulib does not normally generate a source tarball
distribution; instead, developers grab modules directly from the
source repository.

%prep
%setup
%patch1 -p1
%patch2 -p1

install -pm755 %_datadir/gnu-config/config.{guess,sub} build-aux/
# Thanks to USE_POSIX_THREADS_WEAK feature, we have to link
# tests with @LIBMULTITHREAD@ in --no-as-needed mode.
# Starting with commit v0.1-211-gc76f7ed, gnulib sets LIBMULTITHREAD
# to -pthread instead of -lpthread, and gcc -Wl,--no-as-needed does not apply
# to gcc -pthread.
grep -lZ '^test_.*@LIBMULTITHREAD@' modules/*-tests |
	xargs -r0 sed -i 's/^\(test_[^ +=]\+\)\(_LDADD.*\)@LIBMULTITHREAD@\(.*\)/\1\2-lpthread\3\n\1_LDFLAGS = -Wl,--no-as-needed/' --

%build
make info

%install
mkdir -p %buildroot{%_bindir,%_infodir,%_datadir/%name}
cp -a * %buildroot%_datadir/%name/
for f in check-module gnulib-tool; do
	ln -s $(relative %_datadir/%name/$f %_bindir/) %buildroot%_bindir/
done
mv %buildroot%_datadir/%name/doc/*.info %buildroot%_infodir/

%files
%_bindir/*
%_infodir/*
%_datadir/%name/

%changelog
