
%def_disable gpgutils
%define _localstatedir /var

Name: gnupg2
Version: 2.2.10
Release: alt4

Group: Text tools
Summary: The GNU Privacy Guard suite
License: GPLv3+
Url: http://www.gnupg.org/

# ftp://ftp.gnupg.org/gcrypt/gnupg/gnupg-%version.tar.bz2
Source0: gnupg-%version.tar
Source1: gnupg-agent.sh
Source2: gnupg-agent-wrapper.sh

%define docdir %_docdir/gnupg-%version

Provides: newpg = %version-%release
Obsoletes: newpg < %version-%release
Provides: dirmngr = %version-%release
Obsoletes: dirmngr < %version-%release
Provides: gnupg-agent = %version-%release
Provides: %name-agent = %version-%release
Provides: %name-gpg = %version-%release
Provides: %name-common = %version-%release
Obsoletes: %name-agent < %version-%release
Obsoletes: %name-common < %version-%release

# due to "enable -f /usr/lib/bash/lockf lockf"
Requires: bash-builtin-lockf >= 0:0.2

# due to passing OPTION allow-external-password-cache
Conflicts: pinentry < 0.9.2
Conflicts: pinentry-common < 0.9.2
Conflicts: gnupg-pkcs11-scd <= 0.9.2-alt5

# FC
Patch11: gnupg-2.1.21-insttools.patch
Patch12: gnupg-2.1.19-exponential.patch
Patch13: gnupg-2.1.10-secmem.patch
Patch14: gnupg-2.1.1-ocsp-keyusage.patch
Patch15: gnupg-2.1.1-fips-algo.patch
Patch16: gnupg-2.1.21-large-rsa.patch
Patch17: gnupg-2.2.0-file-is-digest.patch
# ALT
Patch101: alt-xloadimage.patch
Patch102: alt-agent-fix-password-request.patch
Patch103: alt-texinfo.patch

# GOST patch/requires/provides
%define gostversion 1.0.0
Patch18: %name-%version-gost-%gostversion.patch
Requires: libgcrypt(vko) >= 1.0.0
Requires: libksba(gost) >= 1.0.0
Provides: %name(gost) = %gostversion

# Issuers patch/provides
%define issuersversion 1.0.0
Patch19: %name-%version-issuers-%issuersversion.patch
Provides: %name(issuersconf) = %issuersversion

BuildRequires(pre): rpm-build-ubt
BuildRequires: libgcrypt-devel >= 1.8.3-alt4
BuildRequires: libksba-devel >= 1.3.6-alt7
BuildRequires: libassuan-devel
BuildRequires: libgnutls-devel libnpth-devel
BuildRequires: bzlib-devel libcurl-devel libldap-devel
BuildRequires: libreadline-devel zlib-devel libusb-devel pkgconfig(sqlite3)
# explicitly added texinfo for info files
BuildRequires: texinfo

%description
GnuPG is GNU's tool for secure communication and data storage.  It can
be used to encrypt data and to create digital signatures.  It includes
an advanced key management facility and is compliant with the proposed
OpenPGP Internet standard as described in RFC2440 and the S/MIME
standard as described by several RFCs.

GnuPG 2.0 is a newer version of GnuPG with additional support for
S/MIME.  It has a different design philosophy that splits
functionality up into several modules.

%prep
%setup -n gnupg-%version
%patch11 -p1
#%patch12 -p1
%patch13 -p1
%patch14 -p1
%patch15 -p1
%patch16 -p1
%patch17 -p1
%patch18 -p1
%patch19 -p1
%patch101 -p1
#%patch102 -p1
%patch103 -p1
rm doc/*.info*

%build
%add_optflags -fno-strict-aliasing
%configure \
	--enable-gpg-is-gpg2 \
	--enable-g13 \
	--enable-large-secmem \
	--disable-rpath \
	--with-capabilities \
	--enable-symcryptrun \
	--with-mailprog=%_sbindir/sendmail \
	--with-pinentry-pgm=%_bindir/pinentry \
	--libexecdir=%_libexecdir/gnupg \
	--with-default-trust-store-file=%_datadir/ca-certificates/ca-bundle.crt \
	--docdir=%docdir
%make_build MAKEINFOFLAGS=--no-split

%install
%makeinstall_std

mkdir -p %buildroot/usr/lib/systemd/user/
install -m 0644 doc/examples/systemd-user/dirmngr.service %buildroot/usr/lib/systemd/user
install -m 0644 doc/examples/systemd-user/dirmngr.socket  %buildroot/usr/lib/systemd/user
install -m 0644 doc/examples/systemd-user/gpg-agent-browser.socket  %buildroot/usr/lib/systemd/user/
install -m 0644 doc/examples/systemd-user/gpg-agent-extra.socket    %buildroot/usr/lib/systemd/user/
install -m 0644 doc/examples/systemd-user/gpg-agent-ssh.socket      %buildroot/usr/lib/systemd/user/
install -m 0644 doc/examples/systemd-user/gpg-agent.service         %buildroot/usr/lib/systemd/user/
install -m 0644 doc/examples/systemd-user/gpg-agent.socket          %buildroot/usr/lib/systemd/user/

install -pDm755 %_sourcedir/gnupg-agent.sh \
	%buildroot%_sysconfdir/profile.d/gnupg-agent.sh
sed -i 's|@LIBEXECDIR@|%_libexecdir|g' \
	%buildroot%_sysconfdir/profile.d/gnupg-agent.sh
install -pDm755 %_sourcedir/gnupg-agent-wrapper.sh \
	%buildroot%_libexecdir/gnupg/gnupg-agent-wrapper

mv %buildroot%_infodir/gnupg{,2}.info

install -pm644 AUTHORS NEWS THANKS %buildroot%docdir/

%find_lang %name

%check
%make_build -k check

%files -f %name.lang
%config %_sysconfdir/profile.d/gnupg-agent.sh
%_bindir/*
%if_disabled gpgutils
%exclude %_bindir/gpg-zip
%exclude %_bindir/gpgsplit
%endif
%_sbindir/*
%_libexecdir/gnupg/
/usr/lib/systemd/user/*.*
%_datadir/gnupg/
%_infodir/*.info*
%_mandir/man?/*
#exclude %_man1dir/gpg-zip.*
%docdir

%changelog
