%def_disable snapshot
%define ver_major 1.52
%def_enable doctool

Name: gobject-introspection
Version: %ver_major.1
Release: alt0.M80P.1

Summary: Introspection system for GObject-based libraries
Group: System/Libraries
License: GPLv2+, LGPLv2+, MIT
URL: https://live.gnome.org/GObjectIntrospection

Provides: gir-repository = %version-%release
Obsoletes: gir-repository

%if_enabled snapshot
Source: %name-%version.tar
%else
Source: ftp://ftp.gnome.org/pub/gnome/sources/%name/%ver_major/%name-%version.tar.xz
%endif

BuildPreReq: libgio-devel >= 2.51.2
BuildRequires: flex gtk-doc libcairo-devel libcairo-gobject-devel libffi-devel libgio-devel
BuildRequires: python-devel python-modules-ctypes python-modules-compiler rpm-build-gir
%{?_enable_doctool:BuildRequires: python-module-mako}

%description
GObject introspection provides tools and libraries to help manage its
common metadata format for representing GObject-based C APIs, designed
for bindings, documentation tools and API verification.

%package x11
Summary: x11-dependent typelibs
Group: System/Libraries
Requires: %name = %version-%release

%description x11
This package provides x11-dependent typelibs from %name package.

%package devel
Summary: Libraries and headers for gobject-introspection
Group: Development/C
Requires: %name = %version-%release libgio-devel rpm-build-gir
Requires: %name-x11 = %version-%release
Provides: gir-repository-devel = %version-%release
Obsoletes: gir-repository-devel

%description devel
GObject introspection provides tools and libraries to help manage its
common metadata format for representing GObject-based C APIs, designed
for bindings, documentation tools and API verification.

This package provides libraries and headers for gobject-introspection.

%package devel-doc
Summary: Documentation for gobject-introspection
Group: Development/C
BuildArch: noarch
Conflicts: %name < %version

%description devel-doc
GObject introspection provides tools and libraries to help manage its
common metadata format for representing GObject-based C APIs, designed
for bindings, documentation tools and API verification.

This package provides development documentation for
gobject-introspection.

%prep
%setup

%build
%autoreconf
%configure \
	--disable-static \
	--enable-gtk-doc \
	%{subst_enable doctool}
%make

%install
%makeinstall_std

%check
#%make check

%files
%_libdir/lib*.so.*
%dir %_typelibdir/
%_typelibdir/DBus-1.0.typelib
%_typelibdir/DBusGLib-1.0.typelib
%_typelibdir/GIRepository-2.0.typelib
%_typelibdir/GL-1.0.typelib
%_typelibdir/GLib-2.0.typelib
%_typelibdir/GModule-2.0.typelib
%_typelibdir/GObject-2.0.typelib
%_typelibdir/Gio-2.0.typelib
%_typelibdir/cairo-1.0.typelib
%_typelibdir/fontconfig-2.0.typelib
%_typelibdir/freetype2-2.0.typelib
%_typelibdir/libxml2-2.0.typelib
%_typelibdir/win32-1.0.typelib

%files x11
%_typelibdir/xfixes-4.0.typelib
%_typelibdir/xft-2.0.typelib
%_typelibdir/xlib-2.0.typelib
%_typelibdir/xrandr-1.3.typelib

%files devel
%_includedir/%name-1.0
%_bindir/g-ir-*
%_libdir/lib*.so
%dir %_libdir/%name
%_libdir/%name/giscanner/
%_pkgconfigdir/*.pc
%_girdir/
%_datadir/%name-1.0
%_datadir/aclocal/*.m4
%_man1dir/*.1*

%files devel-doc
%_datadir/gtk-doc/html/*

%changelog
